/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.instruction.Label;
import net.sf.rej.util.ByteParser;
import net.sf.rej.util.ByteSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionInfo {
    private Label startLabel;
    private Label endLabel;
    private Label handlerLabel;
    private int catchType;
    private ConstantPool pool;

    public ExceptionInfo(ByteParser parser, ConstantPool pool) {
        this.pool = pool;
        int startPc = parser.getShortAsInt();
        int endPc = parser.getShortAsInt();
        int handlerPc = parser.getShortAsInt();
        this.catchType = parser.getShortAsInt();
        this.startLabel = new Label(startPc, "try-block_start(" + this.getType() + ")_" + startPc);
        this.endLabel = new Label(endPc, "try-block_end(" + this.getType() + ")_" + endPc);
        this.handlerLabel = new Label(handlerPc, "exception_handler(" + this.getType() + ")_" + handlerPc);
    }

    public String toString() {
        return "Exception: startpc " + this.getStartPc() + " endpc " + this.getEndPc() + " handlerpc " + this.getHandlerPc() + " catch type " + this.catchType + "(" + this.pool.get(this.catchType) + ")";
    }

    public byte[] getData() {
        ByteSerializer ser = new ByteSerializer(true);
        ser.addShort(this.getStartPc());
        ser.addShort(this.getEndPc());
        ser.addShort(this.getHandlerPc());
        ser.addShort(this.catchType);
        return ser.getBytes();
    }

    public int getStartPc() {
        return this.startLabel.getPosition();
    }

    public int getEndPc() {
        return this.endLabel.getPosition();
    }

    public int getHandlerPc() {
        return this.handlerLabel.getPosition();
    }

    public String getType() {
        ConstantPoolInfo cpi = this.pool.get(this.catchType);
        if (cpi == null) {
            return "(#" + this.catchType + ")";
        }
        return cpi.getValue();
    }

    public boolean isFinally() {
        return this.catchType == 0;
    }

    public List<Label> getLabels() {
        ArrayList<Label> labels = new ArrayList<Label>();
        labels.add(this.startLabel);
        labels.add(this.endLabel);
        labels.add(this.handlerLabel);
        return labels;
    }
}

