/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java;

import java.io.InputStream;
import java.util.ArrayList;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Field;
import net.sf.rej.java.Interface;
import net.sf.rej.java.Method;
import net.sf.rej.java.attribute.Attributes;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.util.ByteArrayByteParser;
import net.sf.rej.util.ByteParser;
import net.sf.rej.util.StreamByteParser;

public class Disassembler {
    public static String parseName(InputStream in) {
        StreamByteParser parser = new StreamByteParser(in);
        parser.setBigEndian(true);
        ClassFile cf = Disassembler.parseBasics(parser);
        return cf.getFullClassName();
    }

    public static ClassFile parseBasics(ByteParser parser) {
        ClassFile cf = new ClassFile();
        cf.validateMagic(parser.getBytes(4));
        cf.setMinorVersion(parser.getShortAsInt());
        cf.setMajorVersion(parser.getShortAsInt());
        int contantPoolCount = parser.getShortAsInt();
        ConstantPool pool = new ConstantPool();
        pool.init(contantPoolCount);
        cf.setPool(pool);
        for (int i = 1; i < contantPoolCount; ++i) {
            ConstantPoolInfo cpi = ConstantPoolInfo.getCPI(parser, pool);
            pool.set(i, cpi);
            if (cpi.getType() != 5 && cpi.getType() != 6) continue;
            ++i;
        }
        cf.setAccessFlags(parser.getShortAsInt());
        cf.setThisClass(parser.getShortAsInt());
        cf.setSuperClass(parser.getShortAsInt());
        return cf;
    }

    public static ClassFile readClass(byte[] data) {
        ByteArrayByteParser parser = new ByteArrayByteParser(data);
        parser.setBigEndian(true);
        ClassFile cf = Disassembler.parseBasics(parser);
        int interfaceCount = parser.getShortAsInt();
        ArrayList<Interface> interfaces = new ArrayList<Interface>(interfaceCount);
        for (int i = 0; i < interfaceCount; ++i) {
            interfaces.add(new Interface(parser.getShortAsInt(), cf.getPool()));
        }
        cf.setInterfaces(interfaces);
        int fieldsCount = parser.getShortAsInt();
        ArrayList<Field> fields = new ArrayList<Field>(fieldsCount);
        for (int i = 0; i < fieldsCount; ++i) {
            Field f = new Field(parser, cf.getPool());
            fields.add(f);
        }
        cf.setFields(fields);
        int methodCount = parser.getShortAsInt();
        ArrayList<Method> methods = new ArrayList<Method>(methodCount);
        for (int i = 0; i < methodCount; ++i) {
            Method method = new Method(parser, cf.getPool());
            methods.add(method);
        }
        cf.setMethods(methods);
        cf.setAttributes(new Attributes(parser, cf.getPool()));
        return cf;
    }
}

