/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.java;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.rej.gui.InstructionHints;
import net.sf.rej.java.Exceptions;
import net.sf.rej.java.InstructionSet;
import net.sf.rej.java.attribute.LineNumberTableAttribute;
import net.sf.rej.java.attribute.LocalVariableTableAttribute;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.Label;
import net.sf.rej.util.ByteParser;
import net.sf.rej.util.ByteSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Code {
    private List<Instruction> code = new ArrayList<Instruction>();
    private List<String> errors = new ArrayList<String>();
    private DecompilationContext context = new DecompilationContext();
    private LineNumberTableAttribute lineNumbers = null;

    public Code(ByteParser parser, ConstantPool pool) {
        this.context.setConstantPool(pool);
        InstructionSet set = InstructionSet.getInstance();
        this.context.setParser(parser);
        this.context.setPosition(0);
        DecompilationContext dc = this.createDecompilationContext();
        ArrayList<Label> labels = new ArrayList<Label>();
        while (parser.hasMore()) {
            int opcode = parser.peekByte();
            try {
                Instruction instruction = set.getInstruction(opcode);
                if (instruction == null) {
                    this.errors.add("Unknown opcode at position " + dc.getPosition() + " trying to recover.");
                    continue;
                }
                int size = instruction.getSize(dc);
                byte[] data = parser.getBytes(size);
                instruction.setData(data, dc);
                List<Label> al = instruction.getLabels();
                if (al != null && al.size() > 0) {
                    labels.addAll(al);
                }
                this.code.add(instruction);
                dc.incrementPosition(size);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.insertLabels(labels);
    }

    public Code(ConstantPool pool) {
        this.context.setConstantPool(pool);
    }

    public void insertLabels(List<Label> labels) {
        if (labels == null) {
            return;
        }
        block0: for (Label label : labels) {
            if (this.code.contains(label)) continue;
            DecompilationContext dc = this.createDecompilationContext();
            for (int j = 0; j < this.code.size(); ++j) {
                Instruction instruction = this.code.get(j);
                if (dc.getPosition() == label.getPosition()) {
                    this.code.add(j, label);
                    continue block0;
                }
                dc.incrementPosition(instruction);
            }
            if (dc.getPosition() != label.getPosition()) continue;
            this.code.add(label);
        }
    }

    public void printCode(PrintStream out, LineNumberTableAttribute lnAttr, LocalVariableTableAttribute lvAttr) {
        InstructionHints hints = new InstructionHints();
        out.println("---- code starts ----");
        DecompilationContext dc = this.createDecompilationContext();
        for (Instruction instruction : this.code) {
            int lineNumber;
            String posStr = String.valueOf(dc.getPosition());
            while (posStr.length() < 5) {
                posStr = " " + posStr;
            }
            String hint = hints.getHint(instruction);
            if (hint.length() > 0) {
                hint = "  (" + hint + ")";
            }
            String lineNumberStr = "     ";
            if (lnAttr != null && (lineNumber = lnAttr.getLineNumber(dc.getPosition())) != -1) {
                lineNumberStr = String.valueOf(lineNumber);
                while (lineNumberStr.length() < 5) {
                    lineNumberStr = " " + lineNumberStr;
                }
            }
            out.println(lineNumberStr + "  " + posStr + " " + " " + instruction.getMnemonic() + " " + instruction.getParameters() + hint);
            dc.incrementPosition(instruction);
        }
        out.println("---- code ends ----");
    }

    public byte[] getData() {
        this.updateLabelPositions();
        ByteSerializer ser = new ByteSerializer(true);
        DecompilationContext dc = this.createDecompilationContext();
        for (Instruction instruction : this.code) {
            ser.addBytes(instruction.getData(dc));
            dc.incrementPosition(instruction);
        }
        return ser.getBytes();
    }

    public List<Instruction> getInstructions() {
        return this.code;
    }

    public DecompilationContext createDecompilationContext() {
        return this.context.createNew();
    }

    public void addInstructionAtPC(int pc, Instruction instruction) {
        DecompilationContext dc = this.createDecompilationContext();
        int pos = -1;
        for (int i = 0; i < this.code.size(); ++i) {
            Instruction otherInst = this.code.get(i);
            if (dc.getPosition() == pc) {
                pos = i;
            } else if (dc.getPosition() > pc) break;
            dc.incrementPosition(otherInst);
        }
        if (pc == 0) {
            pos = 0;
        }
        if (pos == -1) {
            if (dc.getPosition() == pc) {
                pos = this.code.size();
            } else {
                throw new RuntimeException("Could not find given pc " + pc);
            }
        }
        this.add(pos, instruction);
    }

    public void appendInstruction(Instruction instruction) {
        this.add(this.code.size(), instruction);
    }

    public void add(int index, Instruction instruction) {
        this.code.add(index, instruction);
        this.insertLabels(instruction.getLabels());
        this.invalidateLineNumbers();
    }

    public void add(int index, List<Instruction> instructions) {
        this.code.addAll(index, instructions);
        for (Instruction inst : instructions) {
            this.insertLabels(inst.getLabels());
        }
        this.invalidateLineNumbers();
    }

    public int getPosition(Instruction instruction) {
        return this.code.indexOf(instruction);
    }

    public void remove(Instruction instruction) {
        List<Label> labels = instruction.getLabels();
        this.code.remove(instruction);
        if (labels != null) {
            this.code.removeAll(labels);
        }
        this.invalidateLineNumbers();
    }

    public void updateLabelPositions() {
        DecompilationContext dc = this.createDecompilationContext();
        for (Instruction instruction : this.code) {
            if (instruction instanceof Label) {
                ((Label)instruction).setPosition(dc.getPosition());
            }
            dc.incrementPosition(instruction);
        }
    }

    public int getMaxPC() {
        DecompilationContext dc = this.createDecompilationContext();
        for (Instruction instruction : this.code) {
            dc.incrementPosition(instruction);
        }
        return dc.getPosition();
    }

    public void moveUp(Instruction instruction) {
        int pos = this.getPosition(instruction);
        if (pos == 0) {
            return;
        }
        this.code.remove(pos);
        this.code.add(pos - 1, instruction);
        this.invalidateLineNumbers();
    }

    public void moveDown(Instruction instruction) {
        int pos = this.getPosition(instruction);
        if (pos == this.code.size() - 1) {
            return;
        }
        this.code.remove(pos);
        this.code.add(pos + 1, instruction);
        this.invalidateLineNumbers();
    }

    private void invalidateLineNumbers() {
        if (this.lineNumbers != null) {
            this.lineNumbers.invalidate();
        }
    }

    public void setLineNumberTable(LineNumberTableAttribute lineNumbers) {
        this.lineNumbers = lineNumbers;
    }

    public void setLocalVariableTable(LocalVariableTableAttribute lvta) {
        this.context.setLocalVariableTable(lvta);
    }

    public void setExceptions(Exceptions exceptions) {
        this.context.setExceptions(exceptions);
    }
}

