/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sf.rej.gui.EditorFacade;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.event.Event;
import net.sf.rej.gui.event.EventObserver;
import net.sf.rej.gui.event.EventType;
import net.sf.rej.gui.split.StructureSplitSynchronizer;
import net.sf.rej.gui.structure.ClassFileNode;
import net.sf.rej.gui.structure.StructureNode;
import net.sf.rej.gui.tab.Tabbable;
import net.sf.rej.java.ClassFile;
import net.sf.rej.util.Range;

public class StructureTab
extends JPanel
implements Tabbable,
EventObserver {
    private JTree tree = new JTree();
    private ClassFile cf = null;
    private boolean isOpen = false;
    private boolean upToDate = false;
    private StructureSplitSynchronizer sync;
    private Map<Object, Range> offsets;

    public StructureTab() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                StructureTab.this.splitSynchronize();
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                if (me.getButton() == 3) {
                    StructureNode sn;
                    JPopupMenu menu;
                    TreePath path = StructureTab.this.tree.getPathForLocation(me.getX(), me.getY());
                    if (path == null) {
                        return;
                    }
                    Object obj = path.getLastPathComponent();
                    if (obj instanceof StructureNode && (menu = (sn = (StructureNode)obj).getContextMenu()) != null) {
                        menu.show(StructureTab.this.tree, me.getX(), me.getY());
                    }
                }
            }
        });
    }

    public void refresh() {
        if (this.cf != null) {
            ClassFileNode root = new ClassFileNode(this.cf);
            this.tree.setModel(new DefaultTreeModel(root));
            this.offsets = this.cf.getOffsetMap();
            if (this.sync != null) {
                this.sync.setOffsets(this.offsets);
                this.splitSynchronize();
            }
        }
        this.upToDate = true;
    }

    public void redo() {
        EditorFacade.getInstance().performRedo();
    }

    public void undo() {
        EditorFacade.getInstance().performUndo();
    }

    public void insert() {
    }

    public void remove() {
    }

    public void goTo(Link link) {
    }

    public void find() {
    }

    public void findNext() {
    }

    public void processEvent(Event event) {
        try {
            if (event.getType() == EventType.CLASS_OPEN || event.getType() == EventType.CLASS_REPARSE) {
                this.cf = event.getClassFile();
            }
            if (event.getType() == EventType.CLASS_PARSE_ERROR) {
                this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Class parse error.")));
            }
            if (event.getType() == EventType.CLASS_OPEN || event.getType() == EventType.CLASS_UPDATE || event.getType() == EventType.CLASS_REPARSE) {
                this.upToDate = false;
                if (this.isOpen) {
                    this.refresh();
                }
            }
        }
        catch (Exception e) {
            SystemFacade.getInstance().handleException(e);
        }
    }

    public void outline() {
    }

    public void leavingTab() {
        this.isOpen = false;
    }

    public String getTabTitle() {
        return "Structure";
    }

    public void enteringTab() {
        this.isOpen = true;
        if (!this.upToDate) {
            this.refresh();
        }
        this.splitSynchronize();
    }

    public void setSplitSynchronizer(StructureSplitSynchronizer sync) {
        this.sync = sync;
        this.sync.setOffsets(this.offsets);
        this.splitSynchronize();
    }

    private void splitSynchronize() {
        TreePath path;
        if (this.sync != null && this.isOpen && (path = this.tree.getSelectionPath()) != null) {
            StructureNode node = (StructureNode)path.getLastPathComponent();
            this.sync.sync(node);
        }
    }
}

