/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.tab;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import net.sf.rej.gui.EditorFacade;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.event.Event;
import net.sf.rej.gui.event.EventDispatcher;
import net.sf.rej.gui.event.EventObserver;
import net.sf.rej.gui.event.EventType;
import net.sf.rej.gui.hexeditor.ByteArrayDataProvider;
import net.sf.rej.gui.hexeditor.HexEditorPanel;
import net.sf.rej.gui.tab.Tabbable;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Disassembler;

public class HexEditorTab
extends JPanel
implements Tabbable,
EventObserver {
    private ClassFile cf = null;
    private byte[] data = null;
    private HexEditorPanel hexEditor = null;
    private EventDispatcher dispatcher = null;
    boolean modified;
    private boolean isOpen = false;
    private boolean upToDate = false;

    public HexEditorTab() {
        this.setLayout(new BorderLayout());
    }

    public HexEditorPanel getHexEditor() {
        return this.hexEditor;
    }

    public void redo() {
        EditorFacade.getInstance().performUndo();
    }

    public void undo() {
        EditorFacade.getInstance().performRedo();
    }

    public void insert() {
    }

    public void remove() {
    }

    public void goTo(Link link) {
    }

    public void find() {
    }

    public void findNext() {
    }

    public String getTabTitle() {
        return "Hex Editor";
    }

    public void processEvent(Event event) {
        try {
            if (event.getType() == EventType.INIT) {
                this.dispatcher = event.getDispatcher();
            }
            if (event.getType() == EventType.CLASS_OPEN) {
                this.cf = event.getClassFile();
            }
            if (event.getType() == EventType.CLASS_OPEN || event.getType() == EventType.CLASS_UPDATE) {
                this.upToDate = false;
                if (this.isOpen) {
                    this.refresh();
                }
            }
        }
        catch (Exception e) {
            SystemFacade.getInstance().handleException(e);
        }
    }

    public void refresh() {
        if (this.cf != null) {
            if (this.hexEditor != null) {
                this.remove(this.hexEditor);
            }
            this.data = this.cf.getData();
            ByteArrayDataProvider badp = new ByteArrayDataProvider(this.data){

                public void set(int index, byte value) {
                    super.set(index, value);
                    HexEditorTab.this.modified = true;
                }
            };
            this.modified = false;
            this.hexEditor = new HexEditorPanel(badp, 16, false);
            this.add((Component)this.hexEditor, "Center");
            this.validate();
        }
        this.upToDate = true;
    }

    public void outline() {
    }

    public void leavingTab() {
        this.isOpen = false;
        if (this.modified) {
            this.modified = false;
            try {
                this.cf = Disassembler.readClass(this.data);
                Event event = new Event(EventType.CLASS_REPARSE);
                event.setClassFile(this.cf);
                this.dispatcher.notifyObservers(event);
            }
            catch (Exception e) {
                SystemFacade.getInstance().handleException(e);
                this.dispatcher.notifyObservers(new Event(EventType.CLASS_PARSE_ERROR));
            }
        }
    }

    public void enteringTab() {
        this.isOpen = true;
        if (!this.upToDate) {
            this.refresh();
        }
    }
}

