/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.tab;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.rej.files.ClassIndex;
import net.sf.rej.files.ClassLocator;
import net.sf.rej.files.Project;
import net.sf.rej.gui.EditorFacade;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.debug.DebugState;
import net.sf.rej.gui.debug.VMEventHandler;
import net.sf.rej.gui.dialog.ClassChooseDialog;
import net.sf.rej.gui.editor.Breakpoint;
import net.sf.rej.gui.event.Event;
import net.sf.rej.gui.event.EventDispatcher;
import net.sf.rej.gui.event.EventObserver;
import net.sf.rej.gui.event.EventType;
import net.sf.rej.gui.tab.Tabbable;
import net.sf.rej.util.StreamRedirector;

public class DebugTab
extends JPanel
implements Tabbable,
EventObserver {
    private static final Logger logger = Logger.getLogger(DebugTab.class.getName());
    private static final long serialVersionUID = 1L;
    private JRadioButton launchVM = null;
    private JRadioButton attachVM = null;
    private ButtonGroup bg = new ButtonGroup();
    private JPanel statusLabelsPanel = null;
    private JLabel debugStatusLabel = null;
    private JLabel debugStatus = null;
    private JPanel buttonPanel = null;
    private JButton attachButton = null;
    private JButton detachButton = null;
    private JPanel attachOptions = null;
    private JPanel launchOptions = null;
    private JLabel classpathLabel = null;
    private JLabel mainClassLabel = null;
    private JTextField classpathField = null;
    private JTextField mainClassField = null;
    private JLabel methodLabel = null;
    private JLabel hostLabel = null;
    private JLabel portLabel = null;
    private JTextField hostField = null;
    private JTextField portField = null;
    private JComboBox methodCombo = null;
    private JButton selectClassButton = null;
    private JPanel controls = null;
    private JCheckBox suspend = null;
    private VirtualMachine vm = null;
    private VMEventHandler eventHandler = null;
    private DebugState state = DebugState.NOT_ATTACHED;
    private ThreadReference openThread = null;
    private Project project = null;
    private EventDispatcher dispatcher = null;

    public String getTabTitle() {
        return "Debug";
    }

    public void find() {
    }

    public void findNext() {
    }

    public void goTo(Link link) {
    }

    public void insert() {
    }

    public void redo() {
    }

    public void remove() {
    }

    public void undo() {
    }

    public DebugTab() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.gridx = 0;
        gridBagConstraints18.gridy = 4;
        this.setSize(489, 358);
        this.setLayout(new FlowLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)this.getControls(), null);
        this.setState(DebugState.NOT_ATTACHED);
        this.eventHandler = new VMEventHandler();
    }

    private JRadioButton getLaunchVM() {
        if (this.launchVM == null) {
            this.launchVM = new JRadioButton();
            this.bg.add(this.launchVM);
            this.launchVM.setText("Launch new VM");
            this.launchVM.setSelected(true);
        }
        return this.launchVM;
    }

    private JRadioButton getAttachVM() {
        if (this.attachVM == null) {
            this.attachVM = new JRadioButton();
            this.bg.add(this.attachVM);
            this.attachVM.setText("Attach to a running VM");
        }
        return this.attachVM;
    }

    private JPanel getStatusLabelsPanel() {
        if (this.statusLabelsPanel == null) {
            this.debugStatus = new JLabel();
            this.debugStatusLabel = new JLabel();
            this.debugStatusLabel.setText("Status:");
            this.statusLabelsPanel = new JPanel();
            this.statusLabelsPanel.setLayout(new FlowLayout());
            this.statusLabelsPanel.setPreferredSize(new Dimension(100, 500));
            this.statusLabelsPanel.add((Component)this.debugStatusLabel, null);
            this.statusLabelsPanel.add((Component)this.debugStatus, null);
        }
        return this.statusLabelsPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout());
            this.buttonPanel.add((Component)this.getAttachButton(), null);
            this.buttonPanel.add((Component)this.getDetachButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getAttachButton() {
        if (this.attachButton == null) {
            this.attachButton = new JButton();
            this.attachButton.setText("Attach");
            this.attachButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Map<String, Connector.Argument> args;
                    Connector connector;
                    boolean suspend = false;
                    VirtualMachineManager vmm = Bootstrap.virtualMachineManager();
                    if (DebugTab.this.launchVM.isSelected()) {
                        connector = vmm.defaultConnector();
                        args = connector.defaultArguments();
                        String mainClass = DebugTab.this.mainClassField.getText();
                        args.get("options").setValue("-cp \"" + DebugTab.this.project.getFileSet().getClasspath(mainClass) + "\"" + DebugTab.this.classpathField.getText());
                        args.get("suspend").setValue("true");
                        suspend = DebugTab.this.suspend.isSelected();
                        args.get("main").setValue(mainClass);
                        try {
                            DebugTab.this.vm = connector.launch(args);
                            StreamRedirector srErr = new StreamRedirector(DebugTab.this.vm.process().getErrorStream(), System.err);
                            new Thread(srErr).start();
                            StreamRedirector srOut = new StreamRedirector(DebugTab.this.vm.process().getInputStream(), System.out);
                            new Thread(srOut).start();
                        }
                        catch (Exception ex) {
                            SystemFacade.getInstance().handleException(ex);
                            return;
                        }
                    }
                    connector = null;
                    for (AttachingConnector ac : vmm.attachingConnectors()) {
                        if (!ac.transport().name().equals(DebugTab.this.methodCombo.getSelectedItem())) continue;
                        connector = ac;
                        break;
                    }
                    if (connector == null) {
                        SystemFacade.getInstance().setStatus("Attaching connector (" + DebugTab.this.methodCombo.getSelectedItem() + ") not available.");
                        return;
                    }
                    args = connector.defaultArguments();
                    args.get("timeout").setValue("30000");
                    String hostname = DebugTab.this.hostField.getText();
                    if (connector.transport().name().equals("dt_socket")) {
                        if (hostname.length() == 0) {
                            args.get("hostname").setValue("127.0.0.1");
                        } else {
                            args.get("hostname").setValue(hostname);
                        }
                        args.get("port").setValue(DebugTab.this.portField.getText());
                    } else {
                        args.get("name").setValue(hostname);
                    }
                    try {
                        DebugTab.this.vm = connector.attach(args);
                        DebugTab.this.vm.suspend();
                    }
                    catch (Exception ex) {
                        SystemFacade.getInstance().handleException(ex);
                        return;
                    }
                    try {
                        for (Breakpoint bp : EditorFacade.getInstance().getBreakpoints()) {
                            List<ReferenceType> list = DebugTab.this.vm.classesByName(bp.getClassName());
                            if (list.size() > 0) {
                                List<Method> mlist = list.get(0).methodsByName(bp.getMethodName(), bp.getMethodDesc().getRawDesc());
                                if (mlist.size() > 0) {
                                    Location loc = mlist.get(0).locationOfCodeIndex(bp.getPc());
                                    BreakpointRequest bpr = DebugTab.this.vm.eventRequestManager().createBreakpointRequest(loc);
                                    bpr.setSuspendPolicy(2);
                                    bpr.setEnabled(true);
                                    continue;
                                }
                                logger.warning("Error, breakpoint " + bp + " method not found.");
                                continue;
                            }
                            ClassPrepareRequest cpr = DebugTab.this.vm.eventRequestManager().createClassPrepareRequest();
                            cpr.addClassFilter(bp.getClassName());
                            cpr.setEnabled(true);
                        }
                        DebugTab.this.eventHandler.setSuspendOnStartup(suspend);
                        if (!suspend) {
                            DebugTab.this.vm.resume();
                        }
                        DebugTab.this.eventHandler.setVM(DebugTab.this.vm);
                        Thread thread = new Thread(DebugTab.this.eventHandler);
                        thread.start();
                    }
                    catch (Exception ex) {
                        SystemFacade.getInstance().handleException(ex);
                    }
                }
            });
        }
        return this.attachButton;
    }

    private JButton getDetachButton() {
        if (this.detachButton == null) {
            this.detachButton = new JButton();
            this.detachButton.setText("Detach");
            this.detachButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DebugTab.this.eventHandler.setInterrupted(true);
                }
            });
            this.detachButton.setEnabled(false);
        }
        return this.detachButton;
    }

    private JPanel getAttachOptions() {
        if (this.attachOptions == null) {
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 2;
            gridBagConstraints15.gridy = 0;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.gridx = 1;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.fill = 2;
            gridBagConstraints14.gridy = 2;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.gridx = 1;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.gridy = 1;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.gridx = 1;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.anchor = 13;
            gridBagConstraints12.gridy = 2;
            this.portLabel = new JLabel();
            this.portLabel.setText("Port:");
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 13;
            gridBagConstraints11.gridy = 1;
            this.hostLabel = new JLabel();
            this.hostLabel.setText("Host:");
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.gridy = 0;
            this.methodLabel = new JLabel();
            this.methodLabel.setText("Attach method:");
            this.attachOptions = new JPanel();
            this.attachOptions.setLayout(new GridBagLayout());
            this.attachOptions.setPreferredSize(new Dimension(300, 100));
            this.attachOptions.add((Component)this.methodLabel, gridBagConstraints10);
            this.attachOptions.add((Component)this.hostLabel, gridBagConstraints11);
            this.attachOptions.add((Component)this.portLabel, gridBagConstraints12);
            this.attachOptions.add((Component)this.getHostField(), gridBagConstraints13);
            this.attachOptions.add((Component)this.getPortField(), gridBagConstraints14);
            this.attachOptions.add((Component)this.getMethodCombo(), gridBagConstraints15);
        }
        return this.attachOptions;
    }

    private JPanel getLaunchOptions() {
        if (this.launchOptions == null) {
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.gridwidth = 2;
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.gridx = 0;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 2;
            gridBagConstraints16.gridy = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 13;
            gridBagConstraints7.gridy = 1;
            this.mainClassLabel = new JLabel();
            this.mainClassLabel.setText("Main-Class:");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.gridy = 0;
            this.classpathLabel = new JLabel();
            this.classpathLabel.setText("Classpath:");
            this.launchOptions = new JPanel();
            this.launchOptions.setLayout(new GridBagLayout());
            this.launchOptions.setPreferredSize(new Dimension(400, 200));
            this.launchOptions.add((Component)this.classpathLabel, gridBagConstraints6);
            this.launchOptions.add((Component)this.mainClassLabel, gridBagConstraints7);
            this.launchOptions.add((Component)this.getClasspathField(), gridBagConstraints8);
            this.launchOptions.add((Component)this.getMainClassField(), gridBagConstraints9);
            this.launchOptions.add((Component)this.getSelectClassButton(), gridBagConstraints16);
            this.launchOptions.add((Component)this.getSuspend(), gridBagConstraints17);
        }
        return this.launchOptions;
    }

    private JTextField getClasspathField() {
        if (this.classpathField == null) {
            this.classpathField = new JTextField();
            this.classpathField.setColumns(20);
        }
        return this.classpathField;
    }

    private JTextField getMainClassField() {
        if (this.mainClassField == null) {
            this.mainClassField = new JTextField();
            this.mainClassField.setColumns(20);
        }
        return this.mainClassField;
    }

    private JTextField getHostField() {
        if (this.hostField == null) {
            this.hostField = new JTextField();
            this.hostField.setColumns(20);
        }
        return this.hostField;
    }

    private JTextField getPortField() {
        if (this.portField == null) {
            this.portField = new JTextField();
            this.portField.setColumns(20);
        }
        return this.portField;
    }

    private JComboBox getMethodCombo() {
        if (this.methodCombo == null) {
            this.methodCombo = new JComboBox<String>(new String[]{"dt_socket", "dt_shmem"});
        }
        return this.methodCombo;
    }

    private JButton getSelectClassButton() {
        if (this.selectClassButton == null) {
            this.selectClassButton = new JButton();
            this.selectClassButton.setText("...");
            this.selectClassButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassIndex classIndex = SystemFacade.getInstance().getClassIndex();
                    ClassChooseDialog ccd = new ClassChooseDialog((Frame)MainWindow.getInstance(), classIndex);
                    ccd.invoke();
                    ClassLocator locator = ccd.getSelected();
                    if (locator != null) {
                        DebugTab.this.mainClassField.setText(locator.getFullName());
                    }
                }
            });
        }
        return this.selectClassButton;
    }

    private JPanel getControls() {
        if (this.controls == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.gridy = 5;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 0;
            gridBagConstraints19.anchor = 17;
            gridBagConstraints19.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 0.0;
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.weighty = 0.0;
            gridBagConstraints3.gridy = 4;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 3;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.weighty = 0.0;
            gridBagConstraints4.insets = new Insets(0, 50, 0, 0);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.weighty = 0.0;
            gridBagConstraints5.insets = new Insets(0, 50, 0, 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridx = -1;
            this.controls = new JPanel();
            this.controls.setLayout(new GridBagLayout());
            this.controls.setPreferredSize(new Dimension(400, 300));
            this.controls.setMaximumSize(new Dimension(300, 300));
            this.controls.setBorder(BorderFactory.createTitledBorder(null, "Debug Controls", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.controls.add((Component)this.getLaunchVM(), gridBagConstraints);
            this.controls.add((Component)this.getAttachVM(), gridBagConstraints19);
            this.controls.add((Component)this.getButtonPanel(), gridBagConstraints3);
            this.controls.add((Component)this.getLaunchOptions(), gridBagConstraints5);
            this.controls.add((Component)this.getAttachOptions(), gridBagConstraints4);
            this.controls.add((Component)this.getStatusLabelsPanel(), gridBagConstraints21);
        }
        return this.controls;
    }

    private JCheckBox getSuspend() {
        if (this.suspend == null) {
            this.suspend = new JCheckBox();
            this.suspend.setText("Suspend on startup");
        }
        return this.suspend;
    }

    public void setState(DebugState state) {
        this.state = state;
        switch (state) {
            case NOT_ATTACHED: {
                this.debugStatus.setText("Not attached");
                this.debugStatus.setForeground(Color.RED.darker());
                this.attachButton.setEnabled(true);
                this.detachButton.setEnabled(false);
                break;
            }
            case ATTACHED: {
                this.debugStatus.setText("Attached");
                this.debugStatus.setForeground(Color.GREEN.darker());
                this.attachButton.setEnabled(false);
                this.detachButton.setEnabled(true);
            }
        }
    }

    public VirtualMachine getVM() {
        return this.vm;
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        if (this.state == DebugState.ATTACHED) {
            List<ReferenceType> list = this.vm.classesByName(breakpoint.getClassName());
            if (list.size() > 0) {
                List<Method> mlist = list.get(0).methodsByName(breakpoint.getMethodName(), breakpoint.getMethodDesc().getRawDesc());
                if (mlist.size() > 0) {
                    Location loc = mlist.get(0).locationOfCodeIndex(breakpoint.getPc());
                    BreakpointRequest bpr = this.vm.eventRequestManager().createBreakpointRequest(loc);
                    bpr.setSuspendPolicy(2);
                    bpr.setEnabled(true);
                } else {
                    logger.warning("Error, live breakpoint " + breakpoint + " method not found.");
                }
            } else {
                ClassPrepareRequest cpr = this.vm.eventRequestManager().createClassPrepareRequest();
                cpr.addClassFilter(breakpoint.getClassName());
                cpr.setEnabled(true);
            }
        }
    }

    public void removeBreakpoint(Breakpoint breakpoint) {
        if (this.state == DebugState.ATTACHED) {
            ArrayList<BreakpointRequest> removes = new ArrayList<BreakpointRequest>();
            for (BreakpointRequest bpr : this.vm.eventRequestManager().breakpointRequests()) {
                if (!bpr.location().declaringType().name().equals(breakpoint.getClassName()) || !bpr.location().method().name().equals(breakpoint.getMethodName()) || !bpr.location().method().signature().equals(breakpoint.getMethodDesc().getRawDesc()) || bpr.location().codeIndex() != (long)breakpoint.getPc()) continue;
                removes.add(bpr);
            }
            this.vm.eventRequestManager().deleteEventRequests(removes);
        }
    }

    public void setOpenThread(ThreadReference tr) {
        this.openThread = tr;
    }

    public ThreadReference getOpenThread() {
        return this.openThread;
    }

    public void processEvent(Event event) {
        if (event.getType() == EventType.PROJECT_UPDATE) {
            this.project = event.getProject();
        } else if (event.getType() == EventType.INIT) {
            this.dispatcher = event.getDispatcher();
            if (this.eventHandler != null) {
                this.dispatcher.registerObserver(this.eventHandler);
            }
        } else if (event.getType() == EventType.DEBUG_ATTACH) {
            this.setState(DebugState.ATTACHED);
        } else if (event.getType() == EventType.DEBUG_DETACH) {
            this.setState(DebugState.NOT_ATTACHED);
        }
    }

    public void outline() {
    }

    public void leavingTab() {
    }

    public void enteringTab() {
    }
}

