/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.tab;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sf.rej.files.FileSet;
import net.sf.rej.files.Project;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.compare.ComparePanel;
import net.sf.rej.gui.compare.CompareThread;
import net.sf.rej.gui.compare.FileItem;
import net.sf.rej.gui.compare.PackageItem;
import net.sf.rej.gui.compare.Style;
import net.sf.rej.gui.editor.CaseInsensitiveMatcher;
import net.sf.rej.gui.event.Event;
import net.sf.rej.gui.event.EventObserver;
import net.sf.rej.gui.event.EventType;
import net.sf.rej.gui.tab.Tabbable;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Disassembler;

public class CompareTab
extends JPanel
implements Tabbable,
EventObserver {
    Icon folderPlain;
    Icon folderRed;
    Icon folderYellow;
    Icon folderMixed;
    Icon leafPlain;
    Icon leafRed;
    Icon leafYellow;
    Icon leafMixed;
    private static final long serialVersionUID = 1L;
    private Action showDiffAction = new AbstractAction("Show Differences"){

        public void actionPerformed(ActionEvent e) {
            try {
                CompareTab.this.filesetA = SystemFacade.getInstance().getFileSet(new File(CompareTab.this.filenameField1.getText()));
                CompareTab.this.filesetB = SystemFacade.getInstance().getFileSet(new File(CompareTab.this.filenameField2.getText()));
                CompareTab.this.tabbedPane.setSelectedComponent(CompareTab.this.treeScrollPane);
                CompareTab.this.root.removeAllChildren();
                CompareTab.this.root = new DefaultMutableTreeNode("Comparison", true);
                CompareTab.this.model.setRoot(CompareTab.this.root);
                Thread thread = new Thread(new CompareThread(CompareTab.this.filesetA, CompareTab.this.filesetB, CompareTab.this.tree, CompareTab.this.root));
                thread.start();
            }
            catch (Exception ex) {
                SystemFacade.getInstance().handleException(ex);
            }
        }
    };
    private Action setSet1Action = new AbstractAction("Set File/Folder/Archive.."){

        public void actionPerformed(ActionEvent e) {
            CompareTab.this.fileChooser.setFileSelectionMode(2);
            CompareTab.this.fileChooser.setDialogTitle("Select file set 1");
            CompareTab.this.fileChooser.setDialogType(0);
            int i = CompareTab.this.fileChooser.showDialog(CompareTab.this, "Select");
            if (i == 0) {
                CompareTab.this.filenameField1.setText(CompareTab.this.fileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    };
    private Action setSet2Action = new AbstractAction("Set File/Folder/Archive.."){

        public void actionPerformed(ActionEvent e) {
            CompareTab.this.fileChooser.setFileSelectionMode(2);
            CompareTab.this.fileChooser.setDialogTitle("Select file set 2");
            CompareTab.this.fileChooser.setDialogType(0);
            int i = CompareTab.this.fileChooser.showDialog(CompareTab.this, "Select");
            if (i == 0) {
                CompareTab.this.filenameField2.setText(CompareTab.this.fileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    };
    private ComparePanel comparePanel = new ComparePanel();
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel2 = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JLabel set1Label = new JLabel();
    private JTextField filenameField1 = new JTextField();
    private JButton setFileButton1 = new JButton(this.setSet1Action);
    private JLabel set2Label = new JLabel();
    private JTextField filenameField2 = new JTextField();
    private JButton setFileButton2 = new JButton(this.setSet2Action);
    private JButton showDiffButton = new JButton(this.showDiffAction);
    private JFileChooser fileChooser = new JFileChooser();
    private JScrollPane treeScrollPane = new JScrollPane();
    private DefaultMutableTreeNode root = new DefaultMutableTreeNode("Comparison", true);
    private DefaultTreeModel model = new DefaultTreeModel(this.root);
    private JTree tree = new JTree(this.model);
    private JTabbedPane tabbedPane = new JTabbedPane();
    private FileSet filesetA;
    private FileSet filesetB;
    private FileItem selectedItem = null;
    private String lastQueryString = "";
    private CaseInsensitiveMatcher lastSearch = null;

    public CompareTab() {
        try {
            this.folderPlain = new ImageIcon(this.getClass().getResource("/img/folder-plain.png"));
            this.folderRed = new ImageIcon(this.getClass().getResource("/img/folder-red.png"));
            this.folderYellow = new ImageIcon(this.getClass().getResource("/img/folder-yellow.png"));
            this.folderMixed = new ImageIcon(this.getClass().getResource("/img/folder-mixed.png"));
            this.leafPlain = new ImageIcon(this.getClass().getResource("/img/leaf-plain.png"));
            this.leafRed = new ImageIcon(this.getClass().getResource("/img/leaf-red.png"));
            this.leafYellow = new ImageIcon(this.getClass().getResource("/img/leaf-yellow.png"));
            this.leafMixed = new ImageIcon(this.getClass().getResource("/img/leaf-mixed.png"));
        }
        catch (NullPointerException npe) {
            this.folderPlain = new ImageIcon("img/folder-plain.png");
            this.folderRed = new ImageIcon("img/folder-red.png");
            this.folderYellow = new ImageIcon("img/folder-yellow.png");
            this.folderMixed = new ImageIcon("img/folder-mixed.png");
            this.leafPlain = new ImageIcon("img/leaf-plain.png");
            this.leafRed = new ImageIcon("img/leaf-red.png");
            this.leafYellow = new ImageIcon("img/leaf-yellow.png");
            this.leafMixed = new ImageIcon("img/leaf-mixed.png");
        }
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(this.gridBagLayout2);
        this.jPanel2.setLayout(this.gridBagLayout3);
        this.set1Label.setText("Set 1");
        this.filenameField1.setBackground(new Color(255, 100, 100));
        this.filenameField1.setText("");
        this.set2Label.setText("Set 2");
        this.filenameField2.setBackground(new Color(255, 255, 100));
        this.filenameField2.setText("");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        JPanel grid = new JPanel();
        grid.setLayout(new GridLayout(1, 2));
        grid.add(this.jPanel1);
        grid.add(this.jPanel2);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                CompareTab.this.treeClicked(e);
            }
        });
        this.add((Component)grid, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.set1Label, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.filenameField1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.setFileButton1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.set2Label, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.filenameField2, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel2.add((Component)this.setFileButton2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.showDiffButton, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 2.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.addTab("Files", this.treeScrollPane);
        this.tabbedPane.addTab("Compare", this.comparePanel);
        this.treeScrollPane.getViewport().add((Component)this.tree, null);
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object obj = node.getUserObject();
                if (obj instanceof FileItem) {
                    FileItem fileItem = (FileItem)obj;
                    switch (fileItem.getStyle()) {
                        case PLAIN: {
                            this.leafIcon = CompareTab.this.leafPlain;
                            break;
                        }
                        case RED: {
                            this.leafIcon = CompareTab.this.leafRed;
                            break;
                        }
                        case YELLOW: {
                            this.leafIcon = CompareTab.this.leafYellow;
                            break;
                        }
                        case RED_AND_YELLOW: {
                            this.leafIcon = CompareTab.this.leafMixed;
                        }
                    }
                } else if (obj instanceof PackageItem) {
                    PackageItem pkgItem = (PackageItem)obj;
                    switch (pkgItem.getStyle()) {
                        case PLAIN: {
                            this.closedIcon = CompareTab.this.folderPlain;
                            this.openIcon = CompareTab.this.folderPlain;
                            break;
                        }
                        case RED: {
                            this.closedIcon = CompareTab.this.folderRed;
                            this.openIcon = CompareTab.this.folderRed;
                            break;
                        }
                        case YELLOW: {
                            this.closedIcon = CompareTab.this.folderYellow;
                            this.openIcon = CompareTab.this.folderYellow;
                            break;
                        }
                        case RED_AND_YELLOW: {
                            this.closedIcon = CompareTab.this.folderMixed;
                            this.openIcon = CompareTab.this.folderMixed;
                        }
                    }
                } else {
                    this.closedIcon = CompareTab.this.folderPlain;
                    this.openIcon = CompareTab.this.folderPlain;
                }
                if (obj == CompareTab.this.selectedItem) {
                    this.setFont(this.getFont().deriveFont(1));
                } else if (this.getFont() != null) {
                    this.setFont(this.getFont().deriveFont(0));
                }
                return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            }
        });
    }

    public void processEvent(Event event) {
        if (event.getType() == EventType.PROJECT_UPDATE) {
            Project p = event.getProject();
            if (p != null) {
                this.filenameField1.setText(p.getFile().getAbsolutePath());
            } else {
                this.filenameField1.setText("");
            }
        }
    }

    private void treeClicked(MouseEvent e) {
        FileItem ca;
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (selPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        Object userObj = node.getUserObject();
        if (e.getClickCount() == 2 && e.getModifiers() == 16 && userObj instanceof FileItem && (ca = (FileItem)userObj).getFullNameA().endsWith(".class") && ca.getFullNameB().endsWith(".class") && ca.getStyle() != Style.RED && ca.getStyle() != Style.YELLOW) {
            this.selectedItem = ca;
            try {
                byte[] dataA = this.filesetA.getData(ca.getFullNameA());
                byte[] dataB = this.filesetB.getData(ca.getFullNameB());
                ClassFile cfA = Disassembler.readClass(dataA);
                ClassFile cfB = Disassembler.readClass(dataB);
                this.comparePanel.setClassFiles(cfA, cfB);
                this.tabbedPane.setSelectedComponent(this.comparePanel);
            }
            catch (Exception ex) {
                SystemFacade.getInstance().handleException(ex);
            }
        }
    }

    public void redo() {
    }

    public void undo() {
    }

    public void insert() {
    }

    public void remove() {
    }

    public void goTo(Link link) {
    }

    public void find() {
        if (this.tabbedPane.getSelectedComponent() == this.treeScrollPane) {
            String query = (String)JOptionPane.showInputDialog(this, "Search for..", "Search", 3, null, null, this.lastQueryString);
            if (query == null) {
                return;
            }
            this.lastQueryString = query;
            this.lastSearch = new CaseInsensitiveMatcher(query);
            Enumeration<TreeNode> en = this.root.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                FileItem fileItem;
                String filename;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
                Object obj = node.getUserObject();
                if (!(obj instanceof FileItem) || !this.lastSearch.matches(filename = (fileItem = (FileItem)obj).getFullNameA())) continue;
                Object[] path = new Object[]{this.root, node.getParent(), node};
                TreePath tp = new TreePath(path);
                this.tree.setSelectionPath(tp);
                this.tree.startEditingAtPath(tp);
                SystemFacade.getInstance().setStatus("Found '" + query + "'.");
                return;
            }
            this.lastSearch = null;
            SystemFacade.getInstance().setStatus("No occurances of '" + query + "' found.");
        } else {
            this.comparePanel.find();
        }
    }

    public void findNext() {
        if (this.tabbedPane.getSelectedComponent() == this.treeScrollPane) {
            if (this.lastSearch == null) {
                this.find();
            } else {
                Enumeration<TreeNode> en = this.root.breadthFirstEnumeration();
                boolean startSearching = false;
                while (en.hasMoreElements()) {
                    FileItem fileItem;
                    String filename;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
                    if (!startSearching) {
                        if (!node.equals(this.tree.getSelectionPath().getLastPathComponent())) continue;
                        startSearching = true;
                        continue;
                    }
                    Object obj = node.getUserObject();
                    if (!(obj instanceof FileItem) || !this.lastSearch.matches(filename = (fileItem = (FileItem)obj).getFullNameA())) continue;
                    Object[] path = new Object[]{this.root, node.getParent(), node};
                    TreePath tp = new TreePath(path);
                    this.tree.setSelectionPath(tp);
                    this.tree.startEditingAtPath(tp);
                    SystemFacade.getInstance().setStatus("Found '" + this.lastQueryString + "'.");
                    return;
                }
                SystemFacade.getInstance().setStatus("No more occurances of '" + this.lastQueryString + "' found.");
            }
        } else {
            this.comparePanel.findNext();
        }
    }

    public void outline() {
        if (this.tabbedPane.getSelectedComponent() == this.comparePanel) {
            this.comparePanel.outline();
        }
    }

    public void leavingTab() {
    }

    public String getTabTitle() {
        return "Compare";
    }

    public void enteringTab() {
    }
}

