/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.structure;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.action.ModifyClassVersionAction;
import net.sf.rej.gui.dialog.ClassVersionDialog;
import net.sf.rej.gui.structure.StructureNode;
import net.sf.rej.java.ClassFile;

public class VersionNode
extends StructureNode {
    private ClassFile cf;
    private Action modifyAction = new AbstractAction("Change Version.."){

        public void actionPerformed(ActionEvent e) {
            ClassVersionDialog dlg = new ClassVersionDialog(MainWindow.getInstance());
            dlg.invoke(VersionNode.this.cf.getMajorVersion(), VersionNode.this.cf.getMinorVersion());
            if (!dlg.wasCancelled()) {
                SystemFacade.getInstance().performAction(new ModifyClassVersionAction(VersionNode.this.cf, dlg.getVersion()));
            }
        }
    };

    public VersionNode(ClassFile cf) {
        this.cf = cf;
    }

    public String toString() {
        return "Class file version: " + this.cf.getMajorVersion() + "." + this.cf.getMinorVersion() + " (Java " + this.cf.getJavaVersionCompabilityString() + ")";
    }

    public JPopupMenu getContextMenu() {
        JPopupMenu contextMenu = new JPopupMenu();
        contextMenu.add(new JMenuItem(this.modifyAction));
        return contextMenu;
    }
}

