/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.structure;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.gui.structure.AccessFlagsNode;
import net.sf.rej.gui.structure.AttributesNode;
import net.sf.rej.gui.structure.ConstantPoolNode;
import net.sf.rej.gui.structure.FieldsNode;
import net.sf.rej.gui.structure.InterfacesNode;
import net.sf.rej.gui.structure.MagicNode;
import net.sf.rej.gui.structure.MethodsNode;
import net.sf.rej.gui.structure.StructureNode;
import net.sf.rej.gui.structure.SuperClassNode;
import net.sf.rej.gui.structure.ThisClassNode;
import net.sf.rej.gui.structure.VersionNode;
import net.sf.rej.java.ClassFile;

public class ClassFileNode
extends StructureNode {
    private ClassFile cf;
    private List<StructureNode> subNodes;

    public ClassFileNode(ClassFile cf) {
        this.cf = cf;
        this.refresh();
    }

    public String toString() {
        return "Class " + this.cf.getFullClassName();
    }

    public List getChildren() {
        return this.subNodes;
    }

    public void refresh() {
        this.subNodes = new ArrayList<StructureNode>();
        this.subNodes.add(new MagicNode(this.cf));
        this.subNodes.add(new VersionNode(this.cf));
        this.subNodes.add(new ConstantPoolNode(this.cf));
        this.subNodes.add(new AccessFlagsNode(this.cf));
        this.subNodes.add(new ThisClassNode(this.cf));
        this.subNodes.add(new SuperClassNode(this.cf));
        this.subNodes.add(new InterfacesNode(this.cf));
        this.subNodes.add(new FieldsNode(this.cf));
        this.subNodes.add(new MethodsNode(this.cf));
        this.subNodes.add(new AttributesNode(this.cf.getAttributes()));
        for (StructureNode child : this.subNodes) {
            child.setParent(this);
        }
    }
}

