/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.split;

import java.util.Map;
import net.sf.rej.gui.split.HexSplit;
import net.sf.rej.gui.split.StructureSplitSynchronizer;
import net.sf.rej.gui.structure.AccessFlagsNode;
import net.sf.rej.gui.structure.AttributeNode;
import net.sf.rej.gui.structure.AttributesNode;
import net.sf.rej.gui.structure.ClassFileNode;
import net.sf.rej.gui.structure.ConstantPoolNode;
import net.sf.rej.gui.structure.FieldNode;
import net.sf.rej.gui.structure.FieldsNode;
import net.sf.rej.gui.structure.InterfaceNode;
import net.sf.rej.gui.structure.InterfacesNode;
import net.sf.rej.gui.structure.MagicNode;
import net.sf.rej.gui.structure.MethodAccessFlagsNode;
import net.sf.rej.gui.structure.MethodDescriptorNode;
import net.sf.rej.gui.structure.MethodNameNode;
import net.sf.rej.gui.structure.MethodNode;
import net.sf.rej.gui.structure.MethodsNode;
import net.sf.rej.gui.structure.StructureNode;
import net.sf.rej.gui.structure.SuperClassNode;
import net.sf.rej.gui.structure.ThisClassNode;
import net.sf.rej.gui.structure.VersionNode;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Field;
import net.sf.rej.java.Method;
import net.sf.rej.java.attribute.CodeAttribute;
import net.sf.rej.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureToHexSync
implements StructureSplitSynchronizer {
    private HexSplit hexEditor;
    private Map<Object, Range> offsets;

    public StructureToHexSync(HexSplit hexEditor) {
        this.hexEditor = hexEditor;
    }

    @Override
    public void setOffsets(Map<Object, Range> offsets) {
        this.offsets = offsets;
    }

    public Range getRange(StructureNode node) {
        if (node instanceof ClassFileNode) {
            return null;
        }
        if (node instanceof MagicNode) {
            return this.offsets.get((Object)ClassFile.OffsetTag.MAGIC);
        }
        if (node instanceof VersionNode) {
            return this.offsets.get((Object)ClassFile.OffsetTag.VERSION);
        }
        if (node instanceof ConstantPoolNode) {
            return this.offsets.get((Object)ClassFile.OffsetTag.CONSTANT_POOL);
        }
        if (node instanceof AccessFlagsNode) {
            return this.offsets.get((Object)ClassFile.OffsetTag.ACCESS_FLAGS);
        }
        if (node instanceof ThisClassNode) {
            return this.offsets.get((Object)ClassFile.OffsetTag.THIS_CLASS);
        }
        if (node instanceof SuperClassNode) {
            return this.offsets.get((Object)ClassFile.OffsetTag.SUPER_CLASS);
        }
        if (node instanceof InterfacesNode) {
            return this.offsets.get((Object)ClassFile.OffsetTag.INTERFACE_DATA);
        }
        if (node instanceof InterfaceNode) {
            InterfaceNode iNode = (InterfaceNode)node;
            return this.offsets.get(iNode.getInterface());
        }
        if (node instanceof FieldsNode) {
            return this.offsets.get((Object)ClassFile.OffsetTag.FIELD_DATA);
        }
        if (node instanceof FieldNode) {
            FieldNode fNode = (FieldNode)node;
            return this.offsets.get(fNode.getField());
        }
        if (node instanceof MethodsNode) {
            return this.offsets.get((Object)ClassFile.OffsetTag.METHOD_DATA);
        }
        if (node instanceof MethodNode) {
            MethodNode mNode = (MethodNode)node;
            return this.offsets.get(mNode.getMethod());
        }
        if (node instanceof MethodAccessFlagsNode) {
            Range parentRange = this.getRange((StructureNode)node.getParent());
            MethodAccessFlagsNode mafNode = (MethodAccessFlagsNode)node;
            Method method = mafNode.getMethod();
            Range afRange = method.getOffsetMap().get((Object)Method.OffsetTag.ACCESS_FLAGS);
            return afRange.offsetBy(parentRange.getOffset());
        }
        if (node instanceof MethodNameNode) {
            Range parentRange = this.getRange((StructureNode)node.getParent());
            MethodNameNode mafNode = (MethodNameNode)node;
            Method method = mafNode.getMethod();
            Range afRange = method.getOffsetMap().get((Object)Method.OffsetTag.METHOD_NAME);
            return afRange.offsetBy(parentRange.getOffset());
        }
        if (node instanceof MethodDescriptorNode) {
            Range parentRange = this.getRange((StructureNode)node.getParent());
            MethodDescriptorNode mafNode = (MethodDescriptorNode)node;
            Method method = mafNode.getMethod();
            Range afRange = method.getOffsetMap().get((Object)Method.OffsetTag.METHOD_DESCRIPTOR);
            return afRange.offsetBy(parentRange.getOffset());
        }
        if (node instanceof AttributeNode) {
            AttributeNode aNode = (AttributeNode)node;
            AttributesNode an = (AttributesNode)aNode.getParent();
            Range range = this.getRange(an);
            Map<Object, Range> map = an.getAttributesObject().getOffsetMap(range.getOffset());
            return map.get(aNode.getAttributeObject());
        }
        if (node instanceof AttributesNode) {
            StructureNode parent = (StructureNode)node.getParent();
            if (parent instanceof ClassFileNode) {
                return this.offsets.get((Object)ClassFile.OffsetTag.ATTRIBUTES);
            }
            if (parent instanceof MethodNode) {
                MethodNode mNode = (MethodNode)parent;
                Range parentRange = this.getRange(parent);
                Map<Object, Range> map = mNode.getMethod().getOffsetMap();
                return map.get((Object)Method.OffsetTag.ATTRIBUTES).offsetBy(parentRange.getOffset());
            }
            if (parent instanceof FieldNode) {
                FieldNode fNode = (FieldNode)parent;
                Range parentRange = this.getRange(parent);
                Map<Object, Range> map = fNode.getField().getOffsetMap();
                return map.get((Object)Field.OffsetTag.ATTRIBUTES).offsetBy(parentRange.getOffset());
            }
            if (parent instanceof AttributeNode) {
                AttributeNode aNode = (AttributeNode)parent;
                CodeAttribute cAttr = (CodeAttribute)aNode.getAttributeObject();
                Range range = cAttr.getOffsetMap().get((Object)CodeAttribute.OffsetTag.ATTRIBUTES);
                Range parentRange = this.getRange(parent);
                return range.offsetBy(parentRange.getOffset());
            }
            return null;
        }
        return null;
    }

    @Override
    public void sync(StructureNode node) {
        Range range = this.getRange(node);
        if (range == null) {
            this.hexEditor.getHexEditor().getSelectionModel().clearSelection();
        } else {
            this.hexEditor.getHexEditor().getSelectionModel().setSelectedInverval(range.getOffset(), range.getOffset() + range.getSize());
        }
        this.hexEditor.repaint();
        this.hexEditor.getHexEditor().ensureSelectionIsVisible();
    }
}

