/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.split;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.event.Event;
import net.sf.rej.gui.event.EventObserver;
import net.sf.rej.gui.event.EventType;
import net.sf.rej.gui.hexeditor.ByteArrayDataProvider;
import net.sf.rej.gui.hexeditor.HexEditorPanel;
import net.sf.rej.java.ClassFile;

public class HexSplit
extends JPanel
implements EventObserver {
    private boolean active = false;
    private ClassFile cf = null;
    private HexEditorPanel hexEditor = null;

    public HexSplit() {
        this.setLayout(new BorderLayout());
    }

    public void processEvent(Event event) {
        try {
            if (event.getType() == EventType.CLASS_OPEN) {
                this.cf = event.getClassFile();
            }
            if ((event.getType() == EventType.CLASS_OPEN || event.getType() == EventType.CLASS_UPDATE) && this.active) {
                this.refresh();
            }
        }
        catch (Exception e) {
            SystemFacade.getInstance().handleException(e);
        }
    }

    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.refresh();
        }
    }

    public void refresh() {
        if (this.cf != null) {
            if (this.hexEditor != null) {
                this.remove(this.hexEditor);
            }
            byte[] data = this.cf.getData();
            ByteArrayDataProvider badp = new ByteArrayDataProvider(data);
            this.hexEditor = new HexEditorPanel(badp, 16, true);
            this.add((Component)this.hexEditor, "Center");
            this.validate();
        }
    }

    public HexEditorPanel getHexEditor() {
        return this.hexEditor;
    }
}

