/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.split;

import java.util.HashMap;
import java.util.Map;
import net.sf.rej.gui.editor.row.CodeRow;
import net.sf.rej.gui.editor.row.EditorRow;
import net.sf.rej.gui.editor.row.FieldDefRow;
import net.sf.rej.gui.editor.row.MethodDefRow;
import net.sf.rej.gui.split.BytecodeSplitSynchronizer;
import net.sf.rej.gui.split.HexSplit;
import net.sf.rej.java.Method;
import net.sf.rej.java.attribute.CodeAttribute;
import net.sf.rej.java.instruction.DecompilationContext;
import net.sf.rej.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BytecodeToHexSync
implements BytecodeSplitSynchronizer {
    HexSplit hexEditor = null;
    private Map<Object, Range> offsets = null;
    private Map<Method, Map<Object, Range>> methodOffsets = null;

    public BytecodeToHexSync(HexSplit hexEditor) {
        this.hexEditor = hexEditor;
    }

    @Override
    public void setOffsets(Map<Object, Range> offsets) {
        this.offsets = offsets;
        this.methodOffsets = new HashMap<Method, Map<Object, Range>>();
    }

    @Override
    public void sync(EditorRow er) {
        if (er == null) {
            this.hexEditor.getHexEditor().getSelectionModel().clearSelection();
        } else if (er instanceof FieldDefRow) {
            FieldDefRow fdr = (FieldDefRow)er;
            Range offset = this.offsets.get(fdr.getField());
            this.hexEditor.getHexEditor().getSelectionModel().setSelectedInverval(offset.getOffset(), offset.getOffset() + offset.getSize());
        } else if (er instanceof MethodDefRow) {
            MethodDefRow mdr = (MethodDefRow)er;
            Range offset = this.offsets.get(mdr.getMethod());
            this.hexEditor.getHexEditor().getSelectionModel().setSelectedInverval(offset.getOffset(), offset.getOffset() + offset.getSize());
        } else if (er instanceof CodeRow) {
            CodeRow cr = (CodeRow)er;
            Method m = cr.getEnclosingMethodDef().getMethod();
            CodeAttribute ca = m.getAttributes().getCode();
            Map<Object, Range> methodOffsetMap = this.methodOffsets.get(m);
            if (methodOffsetMap == null) {
                methodOffsetMap = m.getOffsetMap();
                this.methodOffsets.put(m, methodOffsetMap);
            }
            Range range = methodOffsetMap.get(ca);
            int offset = this.offsets.get(m).getOffset() + range.getOffset() + 14 + cr.getPosition();
            DecompilationContext dc = ca.getCode().createDecompilationContext();
            dc.setPosition(cr.getPosition());
            int size = cr.getInstruction().getSize(dc);
            this.hexEditor.getHexEditor().getSelectionModel().setSelectedInverval(offset, offset + size);
        } else {
            this.hexEditor.getHexEditor().getSelectionModel().clearSelection();
        }
        this.hexEditor.repaint();
        this.hexEditor.getHexEditor().ensureSelectionIsVisible();
    }
}

