/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.hexeditor;

import java.util.HashSet;
import java.util.Set;

public class SelectionModel {
    private Set<Integer> selected = new HashSet<Integer>();
    private int minIndex = -1;
    private int maxIndex = -1;
    private int size = 0;
    private int subPosition = 0;
    private boolean hexSelection = true;

    public void setSelectedIndex(int index) {
        this.subPosition = 0;
        this.selected.clear();
        this.selected.add(index);
        this.minIndex = index;
        this.maxIndex = index;
    }

    public boolean isSelected(int index) {
        return this.selected.contains(index);
    }

    public void setSelectedInverval(int begin, int end) {
        assert (end >= begin) : "begin must be smaller than end";
        this.subPosition = 0;
        this.minIndex = begin;
        this.maxIndex = end - 1;
        this.selected.clear();
        for (int i = begin; i < end; ++i) {
            this.selected.add(i);
        }
    }

    public void clearSelection() {
        this.subPosition = 0;
        this.selected.clear();
        this.minIndex = -1;
        this.maxIndex = -1;
    }

    public int getMinimumIndex() {
        return this.minIndex;
    }

    public int getMaximumIndex() {
        return this.maxIndex;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int getSubPosition() {
        return this.subPosition;
    }

    public void setSubPosition(int subPosition) {
        assert (subPosition == 0 || subPosition == 1) : "Sub-position must be 0 or 1";
        this.subPosition = subPosition;
    }

    public boolean getHexSelection() {
        return this.hexSelection;
    }

    public void setHexSelection(boolean hexSelection) {
        this.hexSelection = hexSelection;
    }
}

