/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.hexeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.rej.gui.hexeditor.ByteArrayDataProvider;
import net.sf.rej.gui.hexeditor.DataProvider;
import net.sf.rej.gui.hexeditor.DataRow;
import net.sf.rej.gui.hexeditor.Drawer;
import net.sf.rej.gui.hexeditor.HexEditorCellRenderer;
import net.sf.rej.gui.hexeditor.HexEditorKeyListener;
import net.sf.rej.gui.hexeditor.HexEditorMouseListener;
import net.sf.rej.gui.hexeditor.SelectionModel;

public class HexEditorPanel
extends JPanel {
    private DefaultListModel model = new DefaultListModel();
    private JList list = new JList(this.model);
    private DataProvider data;
    private SelectionModel selectionModel = new SelectionModel();
    private HexEditorCellRenderer renderer = new HexEditorCellRenderer(this.selectionModel);
    private HexEditorKeyListener keyListener = new HexEditorKeyListener(this.selectionModel);
    private HexEditorMouseListener mouseListener = new HexEditorMouseListener(this.selectionModel, this.renderer);
    private boolean readOnly;
    private int width;

    public HexEditorPanel(byte[] data, int width, boolean readOnly) {
        this(new ByteArrayDataProvider(data), width, readOnly);
    }

    public HexEditorPanel(DataProvider data, int width, boolean readOnly) {
        this.list.setFont(Drawer.PLAIN);
        this.readOnly = readOnly;
        this.width = width;
        this.selectionModel.setSize(data.getSize());
        this.renderer.setWidth(width);
        this.list.setCellRenderer(this.renderer);
        this.data = data;
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.list), "Center");
        for (int i = 0; i < this.data.getSize(); i += width) {
            DataRow row = new DataRow(this.data, i);
            this.model.addElement(row);
        }
        this.list.setFocusTraversalKeysEnabled(false);
        this.keyListener.setDataProvider(this.data);
        this.keyListener.setReadOnly(this.readOnly);
        this.keyListener.setWidth(width);
        this.list.addKeyListener(this.keyListener);
        this.mouseListener.setWidth(width);
        this.list.addMouseListener(this.mouseListener);
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void ensureSelectionIsVisible() {
        int index = this.selectionModel.getMinimumIndex();
        if (index != -1) {
            this.list.ensureIndexIsVisible(this.selectionModel.getMaximumIndex() / this.width);
            this.list.ensureIndexIsVisible(index / this.width);
        }
    }
}

