/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.hexeditor;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JList;
import net.sf.rej.gui.hexeditor.DataProvider;
import net.sf.rej.gui.hexeditor.SelectionModel;

public class HexEditorKeyListener
implements KeyListener {
    private SelectionModel selectionModel;
    private int width = 0;
    private boolean readOnly;
    private DataProvider dataProvider = null;

    public HexEditorKeyListener(SelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                this.selectionModel.setSelectedIndex(Math.max(0, this.selectionModel.getMinimumIndex() - 1));
                int index = this.selectionModel.getMinimumIndex() / this.width;
                this.setIndex(e, index);
                break;
            }
            case 39: {
                this.selectionModel.setSelectedIndex(Math.min(this.selectionModel.getSize() - 1, this.selectionModel.getMinimumIndex() + 1));
                int index = this.selectionModel.getMinimumIndex() / this.width;
                this.setIndex(e, index);
                break;
            }
            case 38: {
                this.selectionModel.setSelectedIndex(Math.max(0, this.selectionModel.getMinimumIndex() - this.width));
                int index = this.selectionModel.getMinimumIndex() / this.width;
                this.setIndex(e, index);
                break;
            }
            case 40: {
                if (this.selectionModel.getMinimumIndex() == -1) {
                    this.selectionModel.setSelectedIndex(0);
                } else {
                    this.selectionModel.setSelectedIndex(Math.min(this.selectionModel.getSize() - 1, this.selectionModel.getMinimumIndex() + this.width));
                }
                int index = this.selectionModel.getMinimumIndex() / this.width;
                this.setIndex(e, index);
                break;
            }
            case 36: {
                this.selectionModel.setSelectedIndex(0);
                this.setIndex(e, 0);
                break;
            }
            case 35: {
                int index = this.selectionModel.getSize() - 1;
                this.selectionModel.setSelectedIndex(index);
                this.setIndex(e, index / this.width);
                break;
            }
            case 33: {
                JList list = (JList)e.getComponent();
                int count = list.getLastVisibleIndex() - list.getFirstVisibleIndex();
                this.selectionModel.setSelectedIndex(Math.max(0, this.selectionModel.getMinimumIndex() - this.width * count));
                int index = this.selectionModel.getMinimumIndex() / this.width;
                this.setIndex(e, index);
                break;
            }
            case 34: {
                JList list = (JList)e.getComponent();
                int count = list.getLastVisibleIndex() - list.getFirstVisibleIndex();
                if (this.selectionModel.getMinimumIndex() == -1) {
                    this.selectionModel.setSelectedIndex(0);
                } else {
                    this.selectionModel.setSelectedIndex(Math.min(this.selectionModel.getSize() - 1, this.selectionModel.getMinimumIndex() + this.width * count));
                }
                int index = this.selectionModel.getMinimumIndex() / this.width;
                this.setIndex(e, index);
                break;
            }
            case 9: {
                this.selectionModel.setHexSelection(!this.selectionModel.getHexSelection());
                e.consume();
                e.getComponent().repaint();
            }
        }
    }

    private void setIndex(KeyEvent e, int index) {
        JList list = (JList)e.getComponent();
        list.setSelectedIndex(index);
        list.ensureIndexIsVisible(index);
        e.consume();
        list.repaint();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        if (e.getKeyChar() == '\t') {
            return;
        }
        if (this.readOnly) {
            return;
        }
        int index = this.selectionModel.getMinimumIndex();
        if (index >= 0) {
            if (this.selectionModel.getHexSelection()) {
                if (this.selectionModel.getSubPosition() == 0) {
                    int value = this.getValue(e.getKeyChar());
                    if (value != -1) {
                        int oldValue = this.dataProvider.get(index) & 0xFF;
                        int newValue = value * 16 + oldValue % 16;
                        this.dataProvider.set(index, (byte)newValue);
                        this.selectionModel.setSubPosition(1);
                        this.setIndex(e, this.selectionModel.getMinimumIndex() / this.width);
                    }
                } else {
                    int value = this.getValue(e.getKeyChar());
                    if (value != -1) {
                        int oldValue = this.dataProvider.get(index) & 0xFF;
                        int newValue = oldValue - oldValue % 16 + value;
                        this.dataProvider.set(index, (byte)newValue);
                        this.selectionModel.setSelectedIndex(Math.min(this.selectionModel.getSize() - 1, this.selectionModel.getMinimumIndex() + 1));
                        this.setIndex(e, this.selectionModel.getMinimumIndex() / this.width);
                    }
                }
            } else {
                this.dataProvider.set(index, (byte)e.getKeyChar());
                this.selectionModel.setSelectedIndex(Math.min(this.selectionModel.getSize() - 1, this.selectionModel.getMinimumIndex() + 1));
                this.setIndex(e, this.selectionModel.getMinimumIndex() / this.width);
            }
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setDataProvider(DataProvider provider) {
        this.dataProvider = provider;
    }

    private int getValue(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return -1;
    }
}

