/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.hexeditor;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import net.sf.rej.gui.hexeditor.DataRow;
import net.sf.rej.gui.hexeditor.Drawer;
import net.sf.rej.gui.hexeditor.SelectionModel;

public class HexEditorCellRenderer
extends DefaultListCellRenderer {
    private DataRow row = null;
    private SelectionModel selectionModel = null;
    private int width = 0;
    private int hexStart = 0;
    private int asciiStart = 0;
    private int charWidth = 0;
    private String contentLengthString = " ";

    public HexEditorCellRenderer(SelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.row = (DataRow)value;
        return super.getListCellRendererComponent((JList<?>)list, this.contentLengthString, index, isSelected, cellHasFocus);
    }

    public void paint(Graphics g) {
        int i;
        super.paint(g);
        Drawer hd = new Drawer(g, this.getSize());
        hd.draw(this.row.getOffsetString());
        hd.draw(": ");
        this.hexStart = hd.getOffset();
        for (i = 0; i < this.width; ++i) {
            if (this.row.isDataAvailable(i)) {
                hd.draw(this.row.getHexData(i), this.selectionModel.isSelected(this.row.getAbsolute(i)), this.selectionModel.getHexSelection());
                hd.draw(" ");
                continue;
            }
            hd.draw("   ");
        }
        this.asciiStart = hd.getOffset();
        this.charWidth = (this.asciiStart - this.hexStart) / (this.width * 3);
        for (i = 0; i < this.width; ++i) {
            if (this.row.isDataAvailable(i)) {
                hd.draw(String.valueOf(this.row.getAsciiData(i)), this.selectionModel.isSelected(this.row.getAbsolute(i)), !this.selectionModel.getHexSelection());
                continue;
            }
            hd.draw(" ");
        }
    }

    public void setWidth(int width) {
        int i;
        this.width = width;
        StringBuilder sb = new StringBuilder();
        sb.append("        ");
        for (i = 0; i < width; ++i) {
            sb.append("   ");
        }
        for (i = 0; i < width; ++i) {
            sb.append(" ");
        }
        this.contentLengthString = sb.toString();
    }

    public int getIndex(int clickedIndex, MouseEvent e) {
        if (clickedIndex < 0) {
            return -1;
        }
        int base = clickedIndex * this.width;
        if (e.getPoint().x < this.hexStart) {
            return base;
        }
        if (e.getPoint().x < this.asciiStart) {
            int index = (e.getPoint().x - this.hexStart) / (this.charWidth * 3);
            return base + index;
        }
        int index = (e.getPoint().x - this.asciiStart) / this.charWidth;
        if (index < this.width) {
            return base + index;
        }
        return -1;
    }
}

