/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.hexeditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class Drawer {
    public static final Font PLAIN = new Font("Monospaced", 0, 14);
    private static final Color HILITE_SELECTION = new Color(255, 255, 0);
    private static final Color NO_HILITE_SELECTION = new Color(255, 255, 150);
    private Graphics g;
    private int yPos;
    private Dimension d;
    private int offset;
    private FontMetrics fm;

    public Drawer(Graphics g, Dimension d) {
        this.g = g;
        this.d = d;
        this.yPos = d.height - 4;
        this.fm = g.getFontMetrics(PLAIN);
    }

    public void draw(String text) {
        this.draw(text, false, false);
    }

    public void draw(String text, boolean selected, boolean hilite) {
        this.g.setFont(PLAIN);
        int width = this.fm.stringWidth(text);
        if (selected) {
            Color old = this.g.getColor();
            if (hilite) {
                this.g.setColor(HILITE_SELECTION);
            } else {
                this.g.setColor(NO_HILITE_SELECTION);
            }
            this.g.fill3DRect(this.offset, 0, width, this.d.height, true);
            this.g.setColor(old);
        }
        this.g.drawString(text, this.offset, this.yPos);
        this.offset += width;
    }

    public int getOffset() {
        return this.offset;
    }
}

