/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.hexeditor;

import net.sf.rej.gui.hexeditor.DataProvider;
import net.sf.rej.util.ByteToolkit;

public class DataRow {
    private DataProvider data;
    private int offset;

    public DataRow(DataProvider data, int offset) {
        this.data = data;
        this.offset = offset;
    }

    public boolean isDataAvailable(int index) {
        return this.offset + index < this.data.getSize();
    }

    public String getOffsetString() {
        return ByteToolkit.getHexString(this.offset, 6);
    }

    public String getHexData(int index) {
        return ByteToolkit.getHexString(this.data.get(this.offset + index), 2);
    }

    public char getAsciiData(int index) {
        char c = (char)this.data.get(this.offset + index);
        if (c < ' ') {
            c = '.';
        }
        if (c > '\u00e0') {
            c = '.';
        }
        return c;
    }

    public int getAbsolute(int index) {
        return this.offset + index;
    }
}

