/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.rendering;

import java.awt.Color;
import net.sf.rej.gui.editor.rendering.JavaBytecodeSyntaxDrawer;

public class HTMLSyntaxDrawer
implements JavaBytecodeSyntaxDrawer {
    private StringBuilder sb = new StringBuilder();
    private static final Color KEYWORD = new Color(127, 0, 85);
    private static final Color ANNOTATION = new Color(100, 100, 100);
    private static final Color STRING_AND_FIELD = new Color(0, 0, 192);
    private static final Color COMMENT = new Color(63, 127, 95);
    private static final Color DEFAULT = Color.black;

    private String escape(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public void drawIndent() {
        this.sb.append("&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    private static String toBold(String str) {
        return "<B>" + str + "</B>";
    }

    private static String toColor(String str, Color c) {
        int rgb = c.getRGB() & 0xFFFFFF;
        String colorStr = "00000" + Integer.toHexString(rgb);
        colorStr = colorStr.substring(colorStr.length() - 6, colorStr.length());
        return "<FONT COLOR=\"#" + colorStr + "\">" + str + "</FONT>";
    }

    public void drawKeyword(String text) {
        this.sb.append(HTMLSyntaxDrawer.toBold(HTMLSyntaxDrawer.toColor(this.escape(text), KEYWORD)));
    }

    public void drawComment(String text) {
        this.sb.append(HTMLSyntaxDrawer.toColor(this.escape(text), COMMENT));
    }

    public void drawAnnotation(String text) {
        this.sb.append(HTMLSyntaxDrawer.toColor(this.escape(text), ANNOTATION));
    }

    public void drawString(String text) {
        this.sb.append(HTMLSyntaxDrawer.toColor(this.escape(text), STRING_AND_FIELD));
    }

    public void drawField(String text) {
        this.sb.append(HTMLSyntaxDrawer.toColor(this.escape(text), STRING_AND_FIELD));
    }

    public void drawDefault(String text) {
        this.sb.append(HTMLSyntaxDrawer.toColor(this.escape(text), DEFAULT));
    }

    public void drawDefaultOverstrike(String text) {
        this.sb.append(HTMLSyntaxDrawer.toColor(this.escape(text), DEFAULT));
    }

    public void drawInstruction(String text) {
        this.sb.append(HTMLSyntaxDrawer.toBold(HTMLSyntaxDrawer.toColor(this.escape(text), DEFAULT)));
    }

    public void drawSmall(String text, int offset) {
    }

    public void drawLineBreak() {
        this.sb.append("</BR>");
    }

    public void setOffset(int offset) {
    }

    public String getHTML() {
        return this.sb.toString();
    }

    public void drawBreakpoint() {
    }

    public void setExecutionBackground() {
    }
}

