/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.rendering;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import net.sf.rej.Imports;
import net.sf.rej.gui.editor.rendering.BytecodeRenderer;
import net.sf.rej.gui.editor.rendering.GraphicsSyntaxDrawer;
import net.sf.rej.gui.editor.rendering.WidthCalculatorDrawer;
import net.sf.rej.gui.editor.row.EditorRow;

public class CodeEditorRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;
    private EditorRow er = null;
    private boolean isSelected = false;
    private Imports imports;
    private BytecodeRenderer renderer = new BytecodeRenderer();
    private int width = 0;

    public Component getListCellRendererComponent(JList table, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.isSelected = isSelected;
        this.er = (EditorRow)value;
        this.setText(" ");
        WidthCalculatorDrawer wcd = new WidthCalculatorDrawer(table.getGraphics());
        this.renderer.render(this.er, wcd, this.imports);
        this.width = wcd.getMaxWidth();
        return this;
    }

    public void paint(Graphics g) {
        Color bg = this.renderer.getBackgroundColor(this.er);
        if (this.isSelected) {
            bg = bg.darker();
        }
        this.setBackground(bg);
        super.paint(g);
        if (this.er == null) {
            return;
        }
        Dimension d = this.getSize();
        GraphicsSyntaxDrawer sd = new GraphicsSyntaxDrawer(g, d);
        this.renderer.render(this.er, sd, this.imports);
    }

    public void setImports(Imports imports) {
        this.imports = imports;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, super.getPreferredSize().height);
    }
}

