/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.iteration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.rej.files.FileSet;
import net.sf.rej.gui.IterationContext;
import net.sf.rej.gui.IteratorAgentAdapter;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.action.ModifyClassInfoAction;
import net.sf.rej.gui.action.ModifyDescriptor;
import net.sf.rej.gui.action.ModifyNameAndTypeInfoAction;
import net.sf.rej.gui.action.RenameFieldAction;
import net.sf.rej.gui.action.RenameFileAction;
import net.sf.rej.gui.action.RenameMethodAction;
import net.sf.rej.gui.editor.iteration.RefactoringAdvisor;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.Field;
import net.sf.rej.java.JavaType;
import net.sf.rej.java.LocalVariable;
import net.sf.rej.java.Method;
import net.sf.rej.java.constantpool.ClassInfo;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.DescriptorEnabled;
import net.sf.rej.java.constantpool.NameAndTypeInfo;
import net.sf.rej.java.constantpool.RefInfo;

public class RefactoringIterator
extends IteratorAgentAdapter {
    private RefactoringAdvisor advisor;
    private boolean batchMode;
    private Map<String, String> oldClassNames = new HashMap<String, String>();

    public RefactoringIterator(RefactoringAdvisor advisor, boolean batchMode) {
        this.advisor = advisor;
        this.batchMode = batchMode;
    }

    public void postProcessFile(IterationContext ic) {
        ClassFile cf = ic.getCf();
        String oldClassName = this.oldClassNames.get(ic.getCf().getFullClassName());
        if (oldClassName != null) {
            String newFileName = RefactoringIterator.getNewFileName(ic.getFilename(), oldClassName, cf.getFullClassName());
            RenameFileAction u = new RenameFileAction(ic.getProject(), ic.getFilename(), newFileName, ic.getCf());
            if (this.batchMode) {
                FileSet fs = ic.getProject().getFileSet();
                fs.removeFile(ic.getFilename());
                fs.addFile(newFileName);
            } else {
                SystemFacade.getInstance().performProjectAction(u);
            }
            ic.setFilename(newFileName);
        }
    }

    private static String getNewFileName(String filename, String oldClassName, String newClassName) {
        String newFileName = filename.substring(0, filename.lastIndexOf(".class"));
        String oldClassPart = oldClassName.replace('.', '/');
        String newClassPart = newClassName.replace('.', '/');
        newFileName = newFileName.substring(0, newFileName.lastIndexOf(oldClassPart));
        newFileName = newFileName + newClassPart + ".class";
        return newFileName;
    }

    private void processDescriptor(IterationContext ic, Descriptor desc, DescriptorEnabled descEnabled) {
        JavaType ret = desc.getReturn();
        boolean match = false;
        String newClassName = this.advisor.newClassNameFor(ret.getType());
        if (newClassName != null) {
            this.oldClassNames.put(newClassName, ret.getType());
            match = true;
            desc.setReturn(new JavaType(newClassName, ret.getDimensionCount()));
        }
        List<JavaType> params = desc.getParamList();
        ArrayList<JavaType> newParams = new ArrayList<JavaType>();
        for (int i = 0; i < params.size(); ++i) {
            JavaType param = params.get(i);
            newClassName = this.advisor.newClassNameFor(param.getType());
            if (newClassName != null) {
                this.oldClassNames.put(newClassName, param.getType());
                match = true;
                newParams.add(new JavaType(newClassName, param.getDimensionCount()));
                continue;
            }
            newParams.add(param);
        }
        if (match) {
            desc.setParamList(newParams);
            ModifyDescriptor u = new ModifyDescriptor(ic.getCf().getPool(), desc, descEnabled);
            if (this.batchMode) {
                u.execute();
            } else {
                SystemFacade.getInstance().performAction(u, ic.getFilename());
            }
        }
    }

    public void processConstantPoolInfo(IterationContext ic, ConstantPoolInfo cpi) {
        String newMethodName;
        ModifyNameAndTypeInfoAction u;
        NameAndTypeInfo nati;
        String className;
        RefInfo ri;
        ClassInfo ci;
        JavaType jt;
        String newClassName;
        if (cpi.getType() == 7 && (newClassName = this.advisor.newClassNameFor((jt = new JavaType((ci = (ClassInfo)cpi).getName())).getType())) != null) {
            this.oldClassNames.put(newClassName, jt.getType());
            ModifyClassInfoAction u2 = new ModifyClassInfoAction(ic.getCf().getPool(), ci, newClassName + jt.getDimensions());
            if (this.batchMode) {
                u2.execute();
            } else {
                SystemFacade.getInstance().performAction(u2, ic.getFilename());
            }
        }
        if (cpi.getType() == 12) {
            NameAndTypeInfo nati2 = (NameAndTypeInfo)cpi;
            Descriptor desc = nati2.getDescriptor();
            JavaType ret = desc.getReturn();
            boolean match = false;
            String newClassName2 = this.advisor.newClassNameFor(ret.getType());
            if (newClassName2 != null) {
                this.oldClassNames.put(newClassName2, ret.getType());
                match = true;
                desc.setReturn(new JavaType(newClassName2, ret.getDimensionCount()));
            }
            List<JavaType> params = desc.getParamList();
            ArrayList<JavaType> newParams = new ArrayList<JavaType>();
            for (int i = 0; i < params.size(); ++i) {
                JavaType param = params.get(i);
                newClassName2 = this.advisor.newClassNameFor(param.getType());
                if (newClassName2 != null) {
                    this.oldClassNames.put(newClassName2, param.getType());
                    match = true;
                    newParams.add(new JavaType(newClassName2, param.getDimensionCount()));
                    continue;
                }
                newParams.add(param);
            }
            if (match) {
                desc.setParamList(newParams);
                ModifyNameAndTypeInfoAction u3 = new ModifyNameAndTypeInfoAction(ic.getCf().getPool(), nati2, desc);
                if (this.batchMode) {
                    u3.execute();
                } else {
                    SystemFacade.getInstance().performAction(u3, ic.getFilename());
                }
            }
        }
        if (cpi.getType() == 9) {
            ri = (RefInfo)cpi;
            className = ri.getClassName();
            String newFieldName = this.advisor.newFieldNameFor(className, ri.getTargetName(), ri.getDescriptor());
            if (newFieldName != null) {
                nati = ri.getNameAndTypeInfo();
                u = new ModifyNameAndTypeInfoAction(ic.getCf().getPool(), nati, newFieldName);
                if (this.batchMode) {
                    u.execute();
                } else {
                    SystemFacade.getInstance().performAction(u, ic.getFilename());
                }
            }
        } else if ((cpi.getType() == 10 || cpi.getType() == 11) && (newMethodName = this.advisor.newMethodNameFor(className = (ri = (RefInfo)cpi).getClassName(), ri.getTargetName(), ri.getDescriptor())) != null) {
            nati = ri.getNameAndTypeInfo();
            u = new ModifyNameAndTypeInfoAction(ic.getCf().getPool(), nati, newMethodName);
            if (this.batchMode) {
                u.execute();
            } else {
                SystemFacade.getInstance().performAction(u, ic.getFilename());
            }
        }
    }

    public void processLocalVariable(IterationContext ic, LocalVariable lv) {
        Descriptor desc = lv.getDescriptor();
        this.processDescriptor(ic, desc, lv);
    }

    public void processField(IterationContext ic, Field field) {
        Descriptor desc = field.getDescriptor();
        this.processDescriptor(ic, desc, field);
        String className = ic.getCf().getFullClassName();
        String newFieldName = this.advisor.newFieldNameFor(className, field.getName(), field.getDescriptor());
        if (newFieldName != null) {
            RenameFieldAction u = new RenameFieldAction(ic.getCf().getPool(), field, newFieldName);
            if (this.batchMode) {
                u.execute();
            } else {
                SystemFacade.getInstance().performAction(u, ic.getFilename());
            }
        }
    }

    public void processMethod(IterationContext ic, Method method) {
        Descriptor desc = method.getDescriptor();
        this.processDescriptor(ic, desc, method);
        String className = ic.getCf().getFullClassName();
        String newMethodName = this.advisor.newMethodNameFor(className, method.getName(), method.getDescriptor());
        if (newMethodName != null) {
            RenameMethodAction u = new RenameMethodAction(ic.getCf().getPool(), method, newMethodName);
            if (this.batchMode) {
                u.execute();
            } else {
                SystemFacade.getInstance().performAction(u, ic.getFilename());
            }
        }
    }

    public void processException(Exception ex) {
        ex.printStackTrace();
    }
}

