/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.iteration;

import net.sf.rej.gui.IterationContext;
import net.sf.rej.gui.IteratorAgentAdapter;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.tab.Tab;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.Method;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.RefInfo;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.ParameterType;
import net.sf.rej.java.instruction.Parameters;

public class FindMethodRefs
extends IteratorAgentAdapter {
    private int resultCount = 0;
    private String className;
    private String methodName;
    private Descriptor desc;

    public FindMethodRefs(String className, String methodName, Descriptor desc) {
        this.className = className;
        this.methodName = methodName;
        this.desc = desc;
    }

    public void processMethod(IterationContext sc, Method method) {
        boolean classNamesMatch = sc.getCf().getFullClassName().equals(this.className);
        boolean methodNamesMatch = method.getName().equals(this.methodName);
        boolean descriptorsMatch = method.getDescriptor().equals(this.desc);
        if (classNamesMatch && methodNamesMatch && descriptorsMatch) {
            Link link = new Link();
            link.setText("Method definition : " + sc.getCf().getFullClassName() + "." + method.getName());
            link.setAnchor(3);
            link.setProject(sc.getProject());
            link.setFile(sc.getFilename());
            link.setTab(Tab.EDITOR);
            link.setMethod(sc.getMethod());
            MainWindow.getInstance().getSearchTab().addResult(link);
            ++this.resultCount;
        }
    }

    public void processInstruction(IterationContext sc, Instruction instruction) {
        Parameters params = instruction.getParameters();
        for (int i = 0; i < params.getCount(); ++i) {
            if (params.getType(i) != ParameterType.TYPE_CONSTANT_POOL_METHOD_REF) continue;
            ConstantPoolInfo cpi = sc.getDc().getConstantPool().get(params.getInt(i));
            RefInfo ri = (RefInfo)cpi;
            boolean classNamesMatch = ri.getClassName().equals(this.className);
            boolean methodNamesMatch = ri.getTargetName().equals(this.methodName);
            boolean descriptorsMatch = ri.getDescriptor().equals(this.desc);
            if (!classNamesMatch || !methodNamesMatch || !descriptorsMatch) continue;
            String instructionLine = instruction.getMnemonic() + " " + instruction.getParameters().getString(sc.getDc());
            Link link = new Link();
            link.setText("Method Call : " + sc.getCf().getFullClassName() + "." + sc.getMethod().getName() + " / " + instructionLine);
            link.setAnchor(4);
            link.setProject(sc.getProject());
            link.setFile(sc.getFilename());
            link.setTab(Tab.EDITOR);
            link.setMethod(sc.getMethod());
            link.setPosition(sc.getDc().getPosition());
            MainWindow.getInstance().getSearchTab().addResult(link);
            ++this.resultCount;
        }
    }
}

