/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.iteration;

import net.sf.rej.gui.IterationContext;
import net.sf.rej.gui.IteratorAgentAdapter;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.tab.Tab;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.Method;

public class FindMethodDefinition
extends IteratorAgentAdapter {
    private int resultCount = 0;
    private String className;
    private String methodName;
    private Descriptor desc;

    public FindMethodDefinition(String className, String methodName, Descriptor desc) {
        this.className = className;
        this.methodName = methodName;
        this.desc = desc;
    }

    public void processMethod(IterationContext sc, Method method) {
        boolean classNamesMatch = sc.getCf().getFullClassName().equals(this.className);
        boolean methodNamesMatch = method.getName().equals(this.methodName);
        boolean descriptorsMatch = method.getDescriptor().equals(this.desc);
        if (classNamesMatch && methodNamesMatch && descriptorsMatch) {
            Link link = new Link();
            link.setText("Method definition : " + sc.getCf().getFullClassName() + "." + method.getName());
            link.setAnchor(3);
            link.setProject(sc.getProject());
            link.setFile(sc.getFilename());
            link.setTab(Tab.EDITOR);
            link.setMethod(sc.getMethod());
            MainWindow.getInstance().getSearchTab().addResult(link);
            ++this.resultCount;
        }
    }
}

