/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.iteration;

import net.sf.rej.gui.IterationContext;
import net.sf.rej.gui.IteratorAgentAdapter;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.tab.Tab;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.Field;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.java.constantpool.RefInfo;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.ParameterType;
import net.sf.rej.java.instruction.Parameters;

public class FindFieldRefs
extends IteratorAgentAdapter {
    private int resultCount = 0;
    private String className;
    private String fieldName;
    private Descriptor desc;

    public FindFieldRefs(String className, String fieldName, Descriptor desc) {
        this.className = className;
        this.fieldName = fieldName;
        this.desc = desc;
    }

    public void processField(IterationContext sc, Field field) {
        boolean classNamesMatch = sc.getCf().getFullClassName().equals(this.className);
        boolean fieldNamesMatch = field.getName().equals(this.fieldName);
        boolean descriptorsMatch = field.getDescriptor().equals(this.desc);
        if (classNamesMatch && fieldNamesMatch && descriptorsMatch) {
            Link link = new Link();
            link.setText("Field definition : " + sc.getCf().getFullClassName() + "." + field.getName());
            link.setAnchor(2);
            link.setProject(sc.getProject());
            link.setFile(sc.getFilename());
            link.setTab(Tab.EDITOR);
            link.setField(field);
            MainWindow.getInstance().getSearchTab().addResult(link);
            ++this.resultCount;
        }
    }

    public void processInstruction(IterationContext sc, Instruction instruction) {
        Parameters params = instruction.getParameters();
        for (int i = 0; i < params.getCount(); ++i) {
            if (params.getType(i) != ParameterType.TYPE_CONSTANT_POOL_FIELD_REF) continue;
            ConstantPoolInfo cpi = sc.getDc().getConstantPool().get(params.getInt(i));
            RefInfo ri = (RefInfo)cpi;
            boolean classNamesMatch = ri.getClassName().equals(this.className);
            boolean fieldNamesMatch = ri.getTargetName().equals(this.fieldName);
            boolean descriptorsMatch = ri.getDescriptor().equals(this.desc);
            if (!classNamesMatch || !fieldNamesMatch || !descriptorsMatch) continue;
            String instructionLine = instruction.getMnemonic() + " " + instruction.getParameters().getString(sc.getDc());
            Link link = new Link();
            link.setText("Field Ref : " + sc.getCf().getFullClassName() + "." + sc.getMethod().getName() + " / " + instructionLine);
            link.setAnchor(4);
            link.setProject(sc.getProject());
            link.setFile(sc.getFilename());
            link.setTab(Tab.EDITOR);
            link.setMethod(sc.getMethod());
            link.setPosition(sc.getDc().getPosition());
            MainWindow.getInstance().getSearchTab().addResult(link);
            ++this.resultCount;
        }
    }
}

