/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor.iteration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import net.sf.rej.gui.editor.iteration.RefactoringAdvisorAdapter;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.Keywords;
import net.sf.rej.obfuscation.NameSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldNameLegalizingAdvisor
extends RefactoringAdvisorAdapter {
    private static final Logger logger = Logger.getLogger(FieldNameLegalizingAdvisor.class.getName());
    private List<String> classNames;
    private List<String> fieldNames = new ArrayList<String>();
    private HashMap<Key, String> fieldRenames = new HashMap();
    private NameSequence fieldNameSequence = new NameSequence();

    public FieldNameLegalizingAdvisor(List<String> classNames) {
        this.classNames = classNames;
    }

    @Override
    public String newFieldNameFor(String className, String targetName, Descriptor desc) {
        if (this.classNames.contains(className)) {
            Key key = new Key(className, targetName, desc);
            String newFieldName = this.fieldRenames.get(key);
            if (newFieldName == null) {
                if (Keywords.isKeyword(targetName)) {
                    newFieldName = this.getUniqueFieldName(className);
                    this.fieldRenames.put(key, newFieldName);
                    this.fieldNames.add(className + "." + newFieldName);
                    logger.fine("Field rename (illegal name): " + targetName + " => " + newFieldName);
                } else if (this.fieldNames.contains(className + "." + targetName)) {
                    newFieldName = this.getUniqueFieldName(className);
                    this.fieldRenames.put(key, newFieldName);
                    this.fieldNames.add(className + "." + newFieldName);
                    logger.fine("Field rename (duplicate name): " + targetName + " => " + newFieldName);
                } else {
                    this.fieldRenames.put(key, targetName);
                    this.fieldNames.add(className + "." + targetName);
                }
                return newFieldName;
            }
            return newFieldName;
        }
        return null;
    }

    public String getUniqueFieldName(String className) {
        String candidate;
        do {
            candidate = this.fieldNameSequence.getNextName();
        } while (this.fieldNames.contains(className + "." + candidate));
        return candidate;
    }

    public static class Key {
        private String className;
        private String targetName;
        private Descriptor desc;

        public Key(String className, String targetName, Descriptor desc) {
            this.className = className;
            this.targetName = targetName;
            this.desc = desc;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode += this.className.hashCode();
            hashCode *= 63;
            hashCode += this.targetName.hashCode();
            hashCode *= 63;
            return hashCode += this.desc.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return this.className.equals(key.className) && this.targetName.equals(key.targetName) && this.desc.equals(key.desc);
        }
    }
}

