/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class OrderedFilterListModel
implements ListModel {
    private List<ListDataListener> listeners = new ArrayList<ListDataListener>();
    private List<Object> original = new ArrayList<Object>();
    private List<Object> filtered = new ArrayList<Object>();
    private String filter = "";
    private Pattern camelCasePattern = null;
    private static final Comparator<Object> ALPHABETICAL = new Comparator<Object>(){

        @Override
        public int compare(Object arg0, Object arg1) {
            if (arg0 == null || arg1 == null) {
                return 0;
            }
            return arg0.toString().compareToIgnoreCase(arg1.toString());
        }
    };

    public OrderedFilterListModel(Collection c) {
        this.original.addAll(c);
        this.sort();
        this.filtered.addAll(this.original);
    }

    public void sort() {
        Collections.sort(this.original, ALPHABETICAL);
    }

    public int getSize() {
        return this.filtered.size();
    }

    public void filter() {
        int oldSize = this.filtered.size();
        String lcaseFilter = this.filter.toLowerCase();
        this.filtered.clear();
        for (int i = 0; i < this.original.size(); ++i) {
            Object obj = this.original.get(i);
            if (obj.toString().toLowerCase().startsWith(lcaseFilter)) {
                this.filtered.add(obj);
                continue;
            }
            if (this.camelCasePattern == null || !this.camelCasePattern.matcher(obj.toString()).matches()) continue;
            this.filtered.add(obj);
        }
        this.notifyListeners(oldSize);
    }

    public void setFilter(String filter) {
        this.filter = filter;
        StringBuilder exp = new StringBuilder();
        for (int i = 0; i < filter.length(); ++i) {
            char c = filter.charAt(i);
            if (Character.isUpperCase(c)) {
                exp.append("[a-z]*");
            }
            exp.append(c);
        }
        exp.append(".*");
        this.camelCasePattern = Pattern.compile(exp.toString());
    }

    public Object getElementAt(int index) {
        if (index >= this.filtered.size()) {
            return null;
        }
        return this.filtered.get(index);
    }

    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    private void notifyListeners(int oldSize) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListDataListener ldl = this.listeners.get(i);
            ldl.contentsChanged(new ListDataEvent(this, 2, 0, oldSize));
            ldl.contentsChanged(new ListDataEvent(this, 1, 0, this.filtered.size()));
        }
    }
}

