/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.rej.gui.dialog.TypeChooseDialog;
import net.sf.rej.java.AccessFlags;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.JavaType;

public class FieldEditor
extends JDialog {
    private JPanel jContentPane = null;
    private JPanel accessorPanel = null;
    private JCheckBox nativeCheck = null;
    private JCheckBox staticCheck = null;
    private JCheckBox protectedCheck = null;
    private JCheckBox publicCheck = null;
    private JCheckBox synchronizedCheck = null;
    private JCheckBox privateCheck = null;
    private JCheckBox abstractCheck = null;
    private JCheckBox finalCheck = null;
    private JPanel signaturePanel = null;
    private JTextField nameField = null;
    JTextField typeField = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JLabel nameLabel = null;
    private JLabel typeLabel = null;
    private JButton typeButton = null;
    Descriptor desc = null;
    boolean cancelled = false;

    public FieldEditor(Frame owner) {
        super(owner, "Field Editor");
        this.initialize();
    }

    public void invoke(String name, Descriptor type, int flags) {
        this.nameField.setText(name);
        this.desc = type;
        this.typeField.setText(type.getReturn().toString());
        this.publicCheck.setSelected(AccessFlags.isPublic(flags));
        this.staticCheck.setSelected(AccessFlags.isStatic(flags));
        this.synchronizedCheck.setSelected(AccessFlags.isSynchronized(flags));
        this.nativeCheck.setSelected(AccessFlags.isNative(flags));
        this.protectedCheck.setSelected(AccessFlags.isProtected(flags));
        this.privateCheck.setSelected(AccessFlags.isPrivate(flags));
        this.abstractCheck.setSelected(AccessFlags.isAbstract(flags));
        this.finalCheck.setSelected(AccessFlags.isFinal(flags));
        this.pack();
        this.setModal(true);
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public Descriptor getType() {
        return this.desc;
    }

    public String getFieldName() {
        return this.nameField.getText();
    }

    public AccessFlags getAccessFlags() {
        AccessFlags flags = new AccessFlags();
        flags.setAbstract(this.abstractCheck.isSelected());
        flags.setFinal(this.finalCheck.isSelected());
        flags.setNative(this.nativeCheck.isSelected());
        flags.setPrivate(this.privateCheck.isSelected());
        flags.setProtected(this.protectedCheck.isSelected());
        flags.setPublic(this.publicCheck.isSelected());
        flags.setStatic(this.staticCheck.isSelected());
        flags.setSynchronized(this.synchronizedCheck.isSelected());
        return flags;
    }

    private void initialize() {
        this.setSize(270, 234);
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.gridx = 0;
            gridBagConstraints41.fill = 2;
            gridBagConstraints41.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getAccessorPanel(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getSignaturePanel(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints41);
        }
        return this.jContentPane;
    }

    private JPanel getAccessorPanel() {
        if (this.accessorPanel == null) {
            GridLayout gridLayout = new GridLayout(0, 2);
            this.accessorPanel = new JPanel();
            this.accessorPanel.setLayout(gridLayout);
            this.accessorPanel.add((Component)this.getPublicCheck(), null);
            this.accessorPanel.add((Component)this.getStaticCheck(), null);
            this.accessorPanel.add((Component)this.getProtectedCheck(), null);
            this.accessorPanel.add((Component)this.getNativeCheck(), null);
            this.accessorPanel.add((Component)this.getSynchronizedCheck(), null);
            this.accessorPanel.add((Component)this.getPrivateCheck(), null);
            this.accessorPanel.add((Component)this.getAbstractCheck(), null);
            this.accessorPanel.add((Component)this.getFinalCheck(), null);
        }
        return this.accessorPanel;
    }

    private JCheckBox getNativeCheck() {
        if (this.nativeCheck == null) {
            this.nativeCheck = new JCheckBox();
            this.nativeCheck.setText("native");
        }
        return this.nativeCheck;
    }

    private JCheckBox getStaticCheck() {
        if (this.staticCheck == null) {
            this.staticCheck = new JCheckBox();
            this.staticCheck.setText("static");
        }
        return this.staticCheck;
    }

    private JCheckBox getProtectedCheck() {
        if (this.protectedCheck == null) {
            this.protectedCheck = new JCheckBox();
            this.protectedCheck.setText("protected");
        }
        return this.protectedCheck;
    }

    private JCheckBox getPublicCheck() {
        if (this.publicCheck == null) {
            this.publicCheck = new JCheckBox();
            this.publicCheck.setText("public");
        }
        return this.publicCheck;
    }

    private JCheckBox getSynchronizedCheck() {
        if (this.synchronizedCheck == null) {
            this.synchronizedCheck = new JCheckBox();
            this.synchronizedCheck.setText("synchronized");
        }
        return this.synchronizedCheck;
    }

    private JCheckBox getPrivateCheck() {
        if (this.privateCheck == null) {
            this.privateCheck = new JCheckBox();
            this.privateCheck.setText("private");
        }
        return this.privateCheck;
    }

    private JCheckBox getAbstractCheck() {
        if (this.abstractCheck == null) {
            this.abstractCheck = new JCheckBox();
            this.abstractCheck.setText("abstract");
        }
        return this.abstractCheck;
    }

    private JCheckBox getFinalCheck() {
        if (this.finalCheck == null) {
            this.finalCheck = new JCheckBox();
            this.finalCheck.setText("final");
        }
        return this.finalCheck;
    }

    private JPanel getSignaturePanel() {
        if (this.signaturePanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 2;
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 1;
            this.typeLabel = new JLabel();
            this.typeLabel.setText("Type: ");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 0;
            this.nameLabel = new JLabel();
            this.nameLabel.setText("Name: ");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 1.0;
            this.signaturePanel = new JPanel();
            this.signaturePanel.setLayout(new GridBagLayout());
            this.signaturePanel.add((Component)this.getTypeCombo(), gridBagConstraints2);
            this.signaturePanel.add((Component)this.getNameField(), gridBagConstraints4);
            this.signaturePanel.add((Component)this.nameLabel, gridBagConstraints5);
            this.signaturePanel.add((Component)this.typeLabel, gridBagConstraints6);
            this.signaturePanel.add((Component)this.getTypeButton(), gridBagConstraints7);
        }
        return this.signaturePanel;
    }

    private JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
            this.nameField.setColumns(8);
        }
        return this.nameField;
    }

    private JTextField getTypeCombo() {
        if (this.typeField == null) {
            this.typeField = new JTextField();
            this.typeField.setEditable(false);
        }
        return this.typeField;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FieldEditor.this.cancelled = false;
                    FieldEditor.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FieldEditor.this.cancelled = true;
                    FieldEditor.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    private JButton getTypeButton() {
        if (this.typeButton == null) {
            this.typeButton = new JButton();
            this.typeButton.setText("...");
            this.typeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TypeChooseDialog chooser = new TypeChooseDialog(FieldEditor.this);
                    chooser.invoke(FieldEditor.this.desc.getReturn(), true);
                    JavaType newRet = chooser.getType();
                    FieldEditor.this.desc.setReturn(newRet);
                    FieldEditor.this.typeField.setText(newRet.toString());
                }
            });
        }
        return this.typeButton;
    }
}

