/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.rej.files.ClassIndex;
import net.sf.rej.files.ClassLocator;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.dialog.ClassChooseDialog;
import net.sf.rej.java.AccessFlags;
import net.sf.rej.java.Interface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassEditor
extends JDialog {
    Action superClassChooseAction = new AbstractAction("..."){

        public void actionPerformed(ActionEvent e) {
            ClassIndex cpIndex = SystemFacade.getInstance().getClassIndex();
            ClassChooseDialog ccd = new ClassChooseDialog((Dialog)ClassEditor.this, cpIndex);
            ccd.invoke();
            ClassLocator cl = ccd.getSelected();
            if (cl != null) {
                ClassEditor.this.superField.setText(cl.getFullName());
            }
        }
    };
    private JPanel jContentPane = null;
    private JPanel accessorPanel = null;
    private JPanel signaturePanel = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JCheckBox publicCheck = null;
    private JCheckBox staticCheck = null;
    private JCheckBox protectedCheck = null;
    private JCheckBox privateCheck = null;
    private JCheckBox abstractCheck = null;
    private JCheckBox finalCheck = null;
    private JCheckBox interfaceCheck = null;
    private JLabel nameLabel = null;
    JCheckBox superLabel = null;
    private JLabel interfacesLabel = null;
    private JTextField nameField = null;
    JTextField superField = null;
    JButton superChooser = new JButton(this.superClassChooseAction);
    private JScrollPane interfaceScrollPane = null;
    JList interfaceList = null;
    private JButton addButton = null;
    private JButton removeButton = null;
    boolean cancelled = false;
    DefaultListModel interfaceModel = new DefaultListModel();

    public ClassEditor(Frame owner) {
        super(owner);
        this.initialize();
    }

    public void invoke(String className, String superName, int flags, List interfaces) {
        this.nameField.setText(className);
        if (superName == null) {
            this.superField.setText("");
            this.superField.setEnabled(false);
            this.superChooser.setEnabled(false);
            this.superLabel.setSelected(false);
        } else {
            this.superField.setText(superName);
            this.superField.setEnabled(true);
            this.superChooser.setEnabled(true);
            this.superLabel.setSelected(true);
        }
        this.publicCheck.setSelected(AccessFlags.isPublic(flags));
        this.staticCheck.setSelected(AccessFlags.isStatic(flags));
        this.protectedCheck.setSelected(AccessFlags.isProtected(flags));
        this.privateCheck.setSelected(AccessFlags.isPrivate(flags));
        this.abstractCheck.setSelected(AccessFlags.isAbstract(flags));
        this.finalCheck.setSelected(AccessFlags.isFinal(flags));
        this.interfaceCheck.setSelected(AccessFlags.isInterface(flags));
        this.interfaceModel.removeAllElements();
        for (int i = 0; i < interfaces.size(); ++i) {
            Interface intf = (Interface)interfaces.get(i);
            this.interfaceModel.addElement(intf);
        }
        this.pack();
        this.setModal(true);
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    public AccessFlags getFlags() {
        AccessFlags flags = new AccessFlags();
        flags.setAbstract(this.abstractCheck.isSelected());
        flags.setFinal(this.finalCheck.isSelected());
        flags.setInterface(this.interfaceCheck.isSelected());
        flags.setPrivate(this.privateCheck.isSelected());
        flags.setProtected(this.protectedCheck.isSelected());
        flags.setPublic(this.publicCheck.isSelected());
        flags.setStatic(this.staticCheck.isSelected());
        return flags;
    }

    public String getClassName() {
        return this.nameField.getText();
    }

    public String getSuperClassname() {
        if (this.superLabel.isSelected()) {
            return this.superField.getText();
        }
        return null;
    }

    public List<String> getInterfaces() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.interfaceModel.size(); ++i) {
            Object obj = this.interfaceModel.get(i);
            if (obj instanceof String) {
                list.add((String)obj);
                continue;
            }
            Interface intf = (Interface)obj;
            list.add(intf.getName());
        }
        return list;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    private void initialize() {
        this.setSize(450, 233);
        this.setTitle("Class Editor");
        this.setContentPane(this.getJContentPane());
        this.superLabel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ClassEditor.this.superLabel.isSelected()) {
                    ClassEditor.this.superField.setEnabled(true);
                    ClassEditor.this.superChooser.setEnabled(true);
                } else {
                    ClassEditor.this.superField.setEnabled(false);
                    ClassEditor.this.superChooser.setEnabled(false);
                }
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 20, 5, 20);
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getAccessorPanel(), gridBagConstraints);
            this.jContentPane.add((Component)this.getSignaturePanel(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints2);
        }
        return this.jContentPane;
    }

    private JPanel getAccessorPanel() {
        if (this.accessorPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(3);
            this.accessorPanel = new JPanel();
            this.accessorPanel.setLayout(gridLayout);
            this.accessorPanel.add((Component)this.getPublicCheck(), null);
            this.accessorPanel.add((Component)this.getStaticCheck(), null);
            this.accessorPanel.add((Component)this.getProtectedCheck(), null);
            this.accessorPanel.add((Component)this.getPrivateCheck(), null);
            this.accessorPanel.add((Component)this.getAbstractCheck(), null);
            this.accessorPanel.add((Component)this.getFinalCheck(), null);
            this.accessorPanel.add((Component)this.getInterfaceCheck(), null);
            this.accessorPanel.setBorder(BorderFactory.createEtchedBorder());
        }
        return this.accessorPanel;
    }

    private JPanel getSignaturePanel() {
        if (this.signaturePanel == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 2;
            gridBagConstraints10.gridy = 3;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 2;
            gridBagConstraints9.gridy = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 2;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 1.0;
            gridBagConstraints8.gridheight = 2;
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints7b = new GridBagConstraints();
            gridBagConstraints7b.fill = 2;
            gridBagConstraints7b.gridy = 1;
            gridBagConstraints7b.weightx = 0.0;
            gridBagConstraints7b.gridx = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.gridy = 2;
            this.interfacesLabel = new JLabel();
            this.interfacesLabel.setText("Implemented Interfaces:");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(5, 3, 5, 5);
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(5, 5, 5, 2);
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridx = 0;
            this.superLabel = new JCheckBox("Superclass: ");
            this.nameLabel = new JLabel();
            this.nameLabel.setText("Name:");
            this.signaturePanel = new JPanel();
            this.signaturePanel.setLayout(new GridBagLayout());
            this.signaturePanel.add((Component)this.superLabel, gridBagConstraints3);
            this.signaturePanel.add((Component)this.nameLabel, gridBagConstraints4);
            this.signaturePanel.add((Component)this.interfacesLabel, gridBagConstraints5);
            this.signaturePanel.add((Component)this.getNameField(), gridBagConstraints6);
            this.signaturePanel.add((Component)this.getSuperField(), gridBagConstraints7);
            this.signaturePanel.add((Component)this.superChooser, gridBagConstraints7b);
            this.signaturePanel.add((Component)this.getInterfaceScrollPane(), gridBagConstraints8);
            this.signaturePanel.add((Component)this.getAddButton(), gridBagConstraints9);
            this.signaturePanel.add((Component)this.getRemoveButton(), gridBagConstraints10);
        }
        return this.signaturePanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.setRows(1);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(gridLayout1);
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassEditor.this.cancelled = false;
                    ClassEditor.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassEditor.this.cancelled = true;
                    ClassEditor.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    private JCheckBox getPublicCheck() {
        if (this.publicCheck == null) {
            this.publicCheck = new JCheckBox();
            this.publicCheck.setText("public");
        }
        return this.publicCheck;
    }

    private JCheckBox getStaticCheck() {
        if (this.staticCheck == null) {
            this.staticCheck = new JCheckBox();
            this.staticCheck.setText("static");
        }
        return this.staticCheck;
    }

    private JCheckBox getProtectedCheck() {
        if (this.protectedCheck == null) {
            this.protectedCheck = new JCheckBox();
            this.protectedCheck.setText("protected");
        }
        return this.protectedCheck;
    }

    private JCheckBox getPrivateCheck() {
        if (this.privateCheck == null) {
            this.privateCheck = new JCheckBox();
            this.privateCheck.setText("private");
        }
        return this.privateCheck;
    }

    private JCheckBox getAbstractCheck() {
        if (this.abstractCheck == null) {
            this.abstractCheck = new JCheckBox();
            this.abstractCheck.setText("abstract");
        }
        return this.abstractCheck;
    }

    private JCheckBox getFinalCheck() {
        if (this.finalCheck == null) {
            this.finalCheck = new JCheckBox();
            this.finalCheck.setText("final");
        }
        return this.finalCheck;
    }

    private JCheckBox getInterfaceCheck() {
        if (this.interfaceCheck == null) {
            this.interfaceCheck = new JCheckBox();
            this.interfaceCheck.setText("interface");
        }
        return this.interfaceCheck;
    }

    private JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
            this.nameField.setColumns(8);
        }
        return this.nameField;
    }

    private JTextField getSuperField() {
        if (this.superField == null) {
            this.superField = new JTextField();
        }
        return this.superField;
    }

    private JScrollPane getInterfaceScrollPane() {
        if (this.interfaceScrollPane == null) {
            this.interfaceScrollPane = new JScrollPane();
            this.interfaceScrollPane.setViewportView(this.getInterfaceList());
        }
        return this.interfaceScrollPane;
    }

    private JList getInterfaceList() {
        if (this.interfaceList == null) {
            this.interfaceList = new JList(this.interfaceModel);
        }
        return this.interfaceList;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("+");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassIndex cpIndex = SystemFacade.getInstance().getClassIndex();
                    ClassChooseDialog ccd = new ClassChooseDialog((Frame)MainWindow.getInstance(), cpIndex);
                    ccd.invoke();
                    ClassLocator cl = ccd.getSelected();
                    if (cl != null) {
                        ClassEditor.this.interfaceModel.addElement(cl.getFullName());
                        ClassEditor.this.interfaceList.setSelectedValue(cl.getFullName(), true);
                    }
                }
            });
        }
        return this.addButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("-");
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int selected = ClassEditor.this.interfaceList.getSelectedIndex();
                    ClassEditor.this.interfaceModel.remove(selected);
                }
            });
        }
        return this.removeButton;
    }
}

