/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.rej.Imports;
import net.sf.rej.files.ClassIndex;
import net.sf.rej.files.ClassLocator;
import net.sf.rej.gui.EditorFacade;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.dialog.ClassChooseDialog;
import net.sf.rej.gui.editor.LayoutChangeListener;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.constantpool.ClassInfo;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.constantpool.ConstantPoolInfo;
import net.sf.rej.util.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassChooser
extends JPanel {
    private Action chooserAction = new AbstractAction("..."){

        public void actionPerformed(ActionEvent e) {
            ClassIndex cpIndex = SystemFacade.getInstance().getClassIndex();
            ClassChooseDialog ccd = new ClassChooseDialog((Frame)MainWindow.getInstance(), cpIndex);
            ccd.invoke();
            ClassLocator cl = ccd.getSelected();
            if (cl != null) {
                ClassChooser.this.model.addElement(cl);
                ClassChooser.this.combo.setSelectedItem(cl);
                if (ClassChooser.this.layoutChangeListener != null) {
                    ClassChooser.this.layoutChangeListener.layoutChanged(ClassChooser.this);
                }
            }
        }
    };
    DefaultComboBoxModel model = new DefaultComboBoxModel();
    private JLabel label = new JLabel("Class: ");
    JComboBox combo = new JComboBox(this.model);
    private JButton button = new JButton(this.chooserAction);
    private ConstantPool cp = null;
    private ClassFile cf = null;
    private Imports imports = null;
    private LayoutChangeListener layoutChangeListener = null;

    public ClassChooser(LayoutChangeListener layoutChangeListener) {
        this.layoutChangeListener = layoutChangeListener;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.combo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.button, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setClassFile(ClassFile cf) {
        this.cf = cf;
    }

    public void setConstantPool(ConstantPool pool) {
        this.cp = pool;
        this.imports = EditorFacade.getInstance().getImports(this.cf);
        for (int i = 0; i < this.cp.size(); ++i) {
            ConstantPoolInfo cpi = this.cp.get(i);
            if (cpi == null || cpi.getType() != 7) continue;
            this.model.addElement(this.createWrapper((ClassInfo)cpi));
        }
    }

    public Wrapper<ClassInfo> createWrapper(ClassInfo ci) {
        Wrapper<ClassInfo> wrapper = new Wrapper<ClassInfo>();
        wrapper.setContent(ci);
        wrapper.setDisplay(this.imports.getShortName(ci.getName()));
        return wrapper;
    }

    public Object getValue() {
        Object o = this.combo.getSelectedItem();
        int value = 0;
        if (o instanceof String) {
            return o;
        }
        if (o instanceof ClassLocator) {
            ClassLocator cl = (ClassLocator)o;
            return cl.getFullName();
        }
        ClassInfo ci = (ClassInfo)((Wrapper)o).getContent();
        value = this.cp.optionalAdd(ci);
        return value;
    }

    public void setSelected(Object o) {
        this.combo.setSelectedItem(this.createWrapper((ClassInfo)o));
    }

    public void setEditable(boolean b) {
        this.combo.setEditable(b);
    }

    public void setReadOnly() {
        this.combo.setEnabled(false);
    }
}

