/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.editor;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class BasicInfoEditor
extends JDialog {
    private JPanel panel = new JPanel();
    JLabel label = new JLabel("Value: ");
    JTextField value = new JTextField(16);
    JButton doneButton = new JButton("Ok");

    public BasicInfoEditor(Frame frame) {
        super(frame, "", true);
        this.panel.setLayout(new GridBagLayout());
        this.value.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    BasicInfoEditor.this.done();
                }
            }
        });
        this.doneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BasicInfoEditor.this.done();
            }
        });
        this.getContentPane().add(this.panel);
        this.addCenter(this.label, 0, 0);
        this.addCenter(this.value, 1, 0);
        this.addEast(this.doneButton, 1, 1);
        this.pack();
    }

    private void addCenter(Component comp, int x, int y) {
        this.panel.add(comp, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addEast(Component comp, int x, int y) {
        this.panel.add(comp, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void invoke(String title, String previousValue) {
        this.setTitle(title);
        this.value.setText(previousValue);
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public void done() {
        try {
            this.validate(this.value.getText());
            this.setVisible(false);
        }
        catch (ValidationException ve) {
            JOptionPane.showMessageDialog(this, ve.getValidationMessage(), "Validation error", 0);
        }
    }

    public abstract void validate(String var1) throws ValidationException;

    public static class ValidationException
    extends Exception {
        private String validationMessage;

        public ValidationException(String validationMessage) {
            this.validationMessage = validationMessage;
        }

        public String getValidationMessage() {
            return this.validationMessage;
        }
    }
}

