/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.rej.files.ClassIndex;
import net.sf.rej.files.ClassLocator;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.dialog.ClassChooseDialog;
import net.sf.rej.java.JavaType;

public class TypeChooseDialog
extends JDialog {
    private JPanel jContentPane = null;
    private JLabel typeLabel = null;
    private JLabel arrayLabel = null;
    JComboBox typeCombo = null;
    JComboBox arrayCombo = null;
    private JButton typeChooserButton = null;
    private JPanel okCancelPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    DefaultComboBoxModel typeModel;
    DefaultComboBoxModel arrayModel;
    boolean cancelled = false;

    public TypeChooseDialog(Dialog owner) {
        super(owner, true);
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setTitle("Type Chooser");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.gridwidth = 3;
            gridBagConstraints21.gridy = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 2;
            gridBagConstraints11.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridwidth = 1;
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.gridy = 1;
            this.arrayLabel = new JLabel();
            this.arrayLabel.setText("Array Dimensions: ");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 0;
            this.typeLabel = new JLabel();
            this.typeLabel.setText("Type: ");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.typeLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.arrayLabel, gridBagConstraints1);
            this.jContentPane.add((Component)this.getTypeCombo(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getSizeCombo(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getTypeChooserButton(), gridBagConstraints11);
            this.jContentPane.add((Component)this.getOkCancelPanel(), gridBagConstraints21);
        }
        return this.jContentPane;
    }

    private JComboBox getTypeCombo() {
        if (this.typeCombo == null) {
            this.typeModel = new DefaultComboBoxModel();
            this.typeCombo = new JComboBox(this.typeModel);
        }
        return this.typeCombo;
    }

    private JComboBox getSizeCombo() {
        if (this.arrayCombo == null) {
            this.arrayModel = new DefaultComboBoxModel();
            this.arrayCombo = new JComboBox(this.arrayModel);
            this.arrayCombo.setEditable(true);
        }
        return this.arrayCombo;
    }

    private JButton getTypeChooserButton() {
        if (this.typeChooserButton == null) {
            this.typeChooserButton = new JButton();
            this.typeChooserButton.setText("...");
            this.typeChooserButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassIndex cpIndex = SystemFacade.getInstance().getClassIndex();
                    ClassChooseDialog ccd = new ClassChooseDialog((Dialog)TypeChooseDialog.this, cpIndex);
                    ccd.invoke();
                    ClassLocator cl = ccd.getSelected();
                    if (cl != null) {
                        TypeChooseDialog.this.typeModel.addElement(cl);
                        TypeChooseDialog.this.typeCombo.setSelectedItem(cl);
                    }
                }
            });
        }
        return this.typeChooserButton;
    }

    private JPanel getOkCancelPanel() {
        if (this.okCancelPanel == null) {
            this.okCancelPanel = new JPanel();
            this.okCancelPanel.add((Component)this.getOkButton(), null);
            this.okCancelPanel.add((Component)this.getCancelButton(), null);
        }
        return this.okCancelPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TypeChooseDialog.this.cancelled = false;
                    TypeChooseDialog.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TypeChooseDialog.this.cancelled = true;
                    TypeChooseDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    public void invoke(JavaType retType, boolean enableVoid) {
        this.typeModel.removeAllElements();
        if (enableVoid) {
            this.typeModel.addElement("void");
        }
        this.typeModel.addElement("byte");
        this.typeModel.addElement("short");
        this.typeModel.addElement("int");
        this.typeModel.addElement("long");
        this.typeModel.addElement("char");
        this.typeModel.addElement("float");
        this.typeModel.addElement("double");
        if (!retType.isPrimitive()) {
            this.typeModel.addElement(retType.getType());
        }
        this.typeCombo.setSelectedItem(retType.getType());
        this.arrayModel.removeAllElements();
        this.arrayModel.addElement("None");
        this.arrayModel.addElement("1");
        this.arrayModel.addElement("2");
        this.arrayModel.addElement("3");
        if (retType.getDimensionCount() > 3) {
            this.arrayModel.addElement(String.valueOf(retType.getDimensionCount()));
        }
        if (retType.getDimensionCount() == 0) {
            this.arrayCombo.setSelectedItem("None");
        } else {
            this.arrayCombo.setSelectedItem(String.valueOf(retType.getDimensionCount()));
        }
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public JavaType getType() {
        Object item = this.typeCombo.getSelectedItem();
        String name = null;
        if (item instanceof String) {
            name = (String)item;
        } else {
            ClassLocator cl = (ClassLocator)item;
            name = cl.getFullName();
        }
        int dimensions = 0;
        String arrayString = (String)this.arrayCombo.getSelectedItem();
        dimensions = "None".equals(arrayString) ? 0 : Integer.parseInt(arrayString);
        return new JavaType(name, dimensions);
    }
}

