/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.rej.gui.editor.FilterListModel;
import net.sf.rej.gui.editor.row.ClassDefRow;
import net.sf.rej.gui.editor.row.EditorRow;
import net.sf.rej.gui.editor.row.FieldDefRow;
import net.sf.rej.gui.editor.row.MethodDefRow;
import net.sf.rej.gui.editor.row.PackageDefRow;
import net.sf.rej.util.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickOutlineDialog
extends JDialog {
    private JPanel panel = new JPanel();
    JTextField value = new JTextField(16);
    FilterListModel model = null;
    JList list = null;
    JLabel typeCaption = new JLabel("Type: ");
    JLabel typeLabel = new JLabel("");
    JButton okButton = new JButton("OK");
    JButton cancelButton = new JButton("Cancel");
    EditorRow selectedValue = null;

    public QuickOutlineDialog(Frame parent, List<EditorRow> lines) {
        super(parent, "Navigate to..", true);
        this.initialize(lines);
        this.setLocationRelativeTo(parent);
    }

    public QuickOutlineDialog(Dialog parent, List<EditorRow> lines) {
        super(parent, "Navigate to..", true);
        this.initialize(lines);
        this.setLocationRelativeTo(parent);
    }

    private void initialize(List<EditorRow> lines) {
        ArrayList<Object> wrapperItems = new ArrayList<Object>();
        for (EditorRow er : lines) {
            Wrapper<EditorRow> wrapper = new Wrapper<EditorRow>();
            wrapperItems.add(wrapper);
            wrapper.setContent(er);
            if (er instanceof PackageDefRow) {
                PackageDefRow pdr = (PackageDefRow)er;
                wrapper.setDisplay(pdr.getPackage());
                continue;
            }
            if (er instanceof ClassDefRow) {
                ClassDefRow cdr = (ClassDefRow)er;
                wrapper.setDisplay(cdr.getClassFile().getShortClassName());
                continue;
            }
            if (er instanceof FieldDefRow) {
                FieldDefRow fdr = (FieldDefRow)er;
                wrapper.setDisplay(fdr.getField().getName());
                continue;
            }
            if (er instanceof MethodDefRow) {
                MethodDefRow mdr = (MethodDefRow)er;
                wrapper.setDisplay(mdr.getMethod().getName());
                continue;
            }
            throw new AssertionError((Object)("Invalid object type: " + er.getClass()));
        }
        this.model = new FilterListModel(wrapperItems);
        this.model.setFilter(this.value.getText());
        this.model.filter();
        this.list = new JList(this.model);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                QuickOutlineDialog.this.updateType();
            }
        });
        this.panel.setLayout(new GridBagLayout());
        this.value.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    QuickOutlineDialog.this.done();
                } else {
                    QuickOutlineDialog.this.model.setFilter(QuickOutlineDialog.this.value.getText());
                    QuickOutlineDialog.this.model.filter();
                    QuickOutlineDialog.this.list.setSelectedIndex(0);
                    QuickOutlineDialog.this.updateType();
                }
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    QuickOutlineDialog.this.done();
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuickOutlineDialog.this.done();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                QuickOutlineDialog.this.selectedValue = null;
                QuickOutlineDialog.this.setVisible(false);
            }
        });
        this.getContentPane().add(this.panel);
        this.addCenter(this.value, 0, 1, 2);
        this.addCenter(new JScrollPane(this.list), 0, 2, 2);
        this.addEast(this.typeCaption, 0, 3);
        this.addCenter(this.typeLabel, 1, 3);
        this.addCenter(this.okButton, 0, 4);
        this.addCenter(this.cancelButton, 1, 4);
        this.pack();
    }

    private void addCenter(Component comp, int x, int y) {
        this.panel.add(comp, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addCenter(Component comp, int x, int y, int width) {
        this.panel.add(comp, new GridBagConstraints(x, y, width, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addEast(Component comp, int x, int y) {
        this.panel.add(comp, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void invoke() {
        this.setModal(true);
        this.setVisible(true);
    }

    public void done() {
        Wrapper wrapper = (Wrapper)this.list.getSelectedValue();
        if (wrapper != null) {
            this.selectedValue = (EditorRow)wrapper.getContent();
            this.setVisible(false);
        }
    }

    public EditorRow getSelected() {
        return this.selectedValue;
    }

    public void updateType() {
        if (this.model.getSize() == 0) {
            this.typeLabel.setText("");
        }
        EditorRow er = null;
        Wrapper wrapper = (Wrapper)this.list.getSelectedValue();
        if (wrapper != null) {
            er = (EditorRow)wrapper.getContent();
        }
        if (er == null) {
            this.typeLabel.setText("");
        } else if (er instanceof PackageDefRow) {
            this.typeLabel.setText("Package Definition");
        } else if (er instanceof ClassDefRow) {
            this.typeLabel.setText("Class Definition");
        } else if (er instanceof FieldDefRow) {
            this.typeLabel.setText("Field Definition");
        } else if (er instanceof MethodDefRow) {
            this.typeLabel.setText("Method Definition");
        } else {
            throw new AssertionError((Object)("Invalid object type: " + er.getClass()));
        }
    }
}

