/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.rej.gui.dialog.TypeChooseDialog;
import net.sf.rej.java.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterChooseDialog
extends JDialog {
    private JPanel jContentPane = null;
    JList paramList = null;
    private JButton moveDownButton = null;
    private JPanel movePanel = null;
    private JButton moveUpButton = null;
    private JPanel addEditRemovePanel = null;
    private JPanel okCancelPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton addButton = null;
    private JButton editButton = null;
    private JButton removeButton = null;
    DefaultListModel model = new DefaultListModel();
    boolean cancelled = false;

    public ParameterChooseDialog(Dialog owner) {
        super(owner, true);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setTitle("Parameter Chooser");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)new JScrollPane(this.getParamList()), gridBagConstraints);
            this.jContentPane.add((Component)this.getMovePanel(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getAddEditRemovePanel(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getOkCancelPanel(), gridBagConstraints3);
        }
        return this.jContentPane;
    }

    private JList getParamList() {
        if (this.paramList == null) {
            this.paramList = new JList(this.model);
        }
        return this.paramList;
    }

    private JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new JButton();
            this.moveDownButton.setText("Move Down");
            this.moveDownButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index;
                    JavaType jt = (JavaType)ParameterChooseDialog.this.paramList.getSelectedValue();
                    if (jt != null && (index = ParameterChooseDialog.this.paramList.getSelectedIndex()) < ParameterChooseDialog.this.model.size() - 1) {
                        ParameterChooseDialog.this.model.remove(index);
                        ParameterChooseDialog.this.model.add(index + 1, jt);
                        ParameterChooseDialog.this.paramList.setSelectedIndex(index + 1);
                    }
                }
            });
        }
        return this.moveDownButton;
    }

    private JPanel getMovePanel() {
        if (this.movePanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            gridLayout.setHgap(2);
            gridLayout.setVgap(5);
            gridLayout.setColumns(1);
            this.movePanel = new JPanel();
            this.movePanel.setLayout(gridLayout);
            this.movePanel.add((Component)this.getMoveUpButton(), null);
            this.movePanel.add((Component)this.getMoveDownButton(), null);
        }
        return this.movePanel;
    }

    private JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new JButton();
            this.moveUpButton.setText("Move Up");
            this.moveUpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index;
                    JavaType jt = (JavaType)ParameterChooseDialog.this.paramList.getSelectedValue();
                    if (jt != null && (index = ParameterChooseDialog.this.paramList.getSelectedIndex()) > 0) {
                        ParameterChooseDialog.this.model.remove(index);
                        ParameterChooseDialog.this.model.add(index - 1, jt);
                        ParameterChooseDialog.this.paramList.setSelectedIndex(index - 1);
                    }
                }
            });
        }
        return this.moveUpButton;
    }

    private JPanel getAddEditRemovePanel() {
        if (this.addEditRemovePanel == null) {
            this.addEditRemovePanel = new JPanel();
            this.addEditRemovePanel.add((Component)this.getAddButton(), null);
            this.addEditRemovePanel.add((Component)this.getEditButton(), null);
            this.addEditRemovePanel.add((Component)this.getRemoveButton(), null);
        }
        return this.addEditRemovePanel;
    }

    private JPanel getOkCancelPanel() {
        if (this.okCancelPanel == null) {
            this.okCancelPanel = new JPanel();
            this.okCancelPanel.add((Component)this.getOkButton(), null);
            this.okCancelPanel.add((Component)this.getCancelButton(), null);
        }
        return this.okCancelPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ParameterChooseDialog.this.cancelled = false;
                    ParameterChooseDialog.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ParameterChooseDialog.this.cancelled = true;
                    ParameterChooseDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add..");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TypeChooseDialog chooser = new TypeChooseDialog(ParameterChooseDialog.this);
                    chooser.invoke(JavaType.INT, false);
                    if (!chooser.wasCancelled()) {
                        ParameterChooseDialog.this.model.addElement(chooser.getType());
                    }
                }
            });
        }
        return this.addButton;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit..");
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JavaType jt = (JavaType)ParameterChooseDialog.this.paramList.getSelectedValue();
                    if (jt != null) {
                        int index = ParameterChooseDialog.this.paramList.getSelectedIndex();
                        TypeChooseDialog chooser = new TypeChooseDialog(ParameterChooseDialog.this);
                        chooser.invoke(jt, false);
                        if (!chooser.wasCancelled()) {
                            ParameterChooseDialog.this.model.remove(index);
                            ParameterChooseDialog.this.model.add(index, chooser.getType());
                        }
                        ParameterChooseDialog.this.paramList.setSelectedIndex(index);
                    }
                }
            });
        }
        return this.editButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("Remove");
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JavaType jt = (JavaType)ParameterChooseDialog.this.paramList.getSelectedValue();
                    if (jt != null) {
                        ParameterChooseDialog.this.model.removeElement(jt);
                    }
                }
            });
        }
        return this.removeButton;
    }

    public void invoke(List params) {
        this.model.removeAllElements();
        for (int i = 0; i < params.size(); ++i) {
            this.model.addElement(params.get(i));
        }
        this.setVisible(true);
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public List<JavaType> getParams() {
        ArrayList<JavaType> params = new ArrayList<JavaType>(this.model.size());
        for (Object obj : this.model.toArray()) {
            params.add((JavaType)obj);
        }
        return params;
    }
}

