/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class NewClassDialog
extends JDialog {
    private static final String DEFAULT_PKG_STRING = "[Default]";
    private DefaultComboBoxModel model = null;
    private JComboBox packageCombo = new JComboBox();
    private JTextField classField = new JTextField(20);
    private JTextField fileField = new JTextField(20);
    boolean cancelled = true;
    private Action okAction = new AbstractAction("OK"){

        public void actionPerformed(ActionEvent e) {
            NewClassDialog.this.cancelled = false;
            NewClassDialog.this.done();
        }
    };
    private Action cancelAction = new AbstractAction("Cancel"){

        public void actionPerformed(ActionEvent e) {
            NewClassDialog.this.cancelled = true;
            NewClassDialog.this.done();
        }
    };
    KeyListener keyListener = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                NewClassDialog.this.cancelled = false;
                NewClassDialog.this.done();
            } else {
                NewClassDialog.this.updateFileName();
            }
        }
    };
    ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            NewClassDialog.this.updateFileName();
        }
    };

    public NewClassDialog(JFrame parent) {
        super(parent, "Create new class", true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.model = new DefaultComboBoxModel();
        this.model.addElement(DEFAULT_PKG_STRING);
        this.packageCombo.setEditable(true);
        this.packageCombo.addKeyListener(this.keyListener);
        this.packageCombo.addActionListener(this.actionListener);
        this.classField.addKeyListener(this.keyListener);
        this.packageCombo.setModel(this.model);
        this.addCenter(new JLabel("Package: "), 0, 0);
        this.addCenter(this.packageCombo, 1, 0);
        this.addEast(new JLabel("Class: "), 0, 1);
        this.addCenter(this.classField, 1, 1);
        this.addEast(new JLabel("File: "), 0, 2);
        this.addCenter(this.fileField, 1, 2);
        this.addCenter(new JButton(this.okAction), 0, 3);
        this.addCenter(new JButton(this.cancelAction), 1, 3);
        this.pack();
    }

    private void addCenter(Component comp, int x, int y) {
        this.getContentPane().add(comp, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addEast(Component comp, int x, int y) {
        this.getContentPane().add(comp, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void invoke() {
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public boolean userCancelled() {
        return this.cancelled;
    }

    public String getSelectedPackage() {
        return (String)this.packageCombo.getSelectedItem();
    }

    public String getFullClassName() {
        String pkg = (String)this.packageCombo.getSelectedItem();
        if (DEFAULT_PKG_STRING.equals(pkg)) {
            return this.classField.getText();
        }
        return pkg + "." + this.classField.getText();
    }

    public String getSelectedClass() {
        return this.classField.getText();
    }

    public String getSelectedFile() {
        return this.fileField.getText();
    }

    void done() {
        this.setVisible(false);
    }

    void updateFileName() {
        String pkg = (String)this.packageCombo.getSelectedItem();
        if (DEFAULT_PKG_STRING.equals(pkg)) {
            this.fileField.setText(this.classField.getText() + ".class");
        } else {
            this.fileField.setText(pkg.replace('.', '/') + "/" + this.classField.getText() + ".class");
        }
    }
}

