/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import net.sf.rej.files.ClassIndex;
import net.sf.rej.files.ClassLocator;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.dialog.ClassChooseDialog;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Method;
import net.sf.rej.util.Wrapper;

public class MethodChooseDialog
extends JDialog {
    private Action classChooserAction = new AbstractAction("..."){

        public void actionPerformed(ActionEvent e) {
            ClassIndex cpIndex = SystemFacade.getInstance().getClassIndex();
            ClassChooseDialog ccd = new ClassChooseDialog((Frame)MainWindow.getInstance(), cpIndex);
            ccd.invoke();
            ClassLocator cl = ccd.getSelected();
            if (cl != null) {
                MethodChooseDialog.this.clsModel.addElement(cl);
                MethodChooseDialog.this.cls.setSelectedItem(cl);
                MethodChooseDialog.this.updateMethodList();
            }
        }
    };
    private Container panel = this.getContentPane();
    private JLabel label = new JLabel("Select method", 0);
    private JLabel classCaption = new JLabel("Class: ");
    private JLabel methodCaption = new JLabel("Method: ");
    DefaultComboBoxModel clsModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel methodModel = new DefaultComboBoxModel();
    JComboBox cls = new JComboBox(this.clsModel);
    private JButton clsButton = new JButton(this.classChooserAction);
    private JComboBox method = new JComboBox(this.methodModel);
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    ClassLocator selectedClass = null;
    Method selectedMethod = null;

    public MethodChooseDialog(Frame frame, ClassLocator defaultClass) {
        super(frame, "Choose Method", true);
        this.clsModel.addElement(defaultClass);
        this.cls.setSelectedItem(defaultClass);
        this.updateMethodList();
        this.panel.setLayout(new GridBagLayout());
        this.method.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MethodChooseDialog.this.done();
                }
            }
        });
        this.cls.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MethodChooseDialog.this.updateMethodList();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodChooseDialog.this.done();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MethodChooseDialog.this.selectedClass = null;
                MethodChooseDialog.this.selectedMethod = null;
                MethodChooseDialog.this.setVisible(false);
            }
        });
        this.addCenter(this.label, 0, 0, 4);
        this.addEast(this.classCaption, 0, 1);
        this.addCenter(this.cls, 1, 1, 2);
        this.addCenter(this.clsButton, 3, 1, 1);
        this.addEast(this.methodCaption, 0, 2);
        this.addCenter(this.method, 1, 2, 3);
        this.addCenter(this.okButton, 0, 3, 2);
        this.addCenter(this.cancelButton, 2, 3, 2);
        this.pack();
    }

    private void addCenter(Component comp, int x, int y, int width) {
        this.panel.add(comp, new GridBagConstraints(x, y, width, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void addEast(Component comp, int x, int y) {
        this.panel.add(comp, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    public void invoke() {
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public void done() {
        this.selectedClass = (ClassLocator)this.cls.getSelectedItem();
        this.selectedMethod = null;
        Wrapper wrapper = (Wrapper)this.method.getSelectedItem();
        if (wrapper != null) {
            this.selectedMethod = (Method)wrapper.getContent();
        }
        this.setVisible(false);
    }

    public ClassLocator getSelectedClass() {
        return this.selectedClass;
    }

    public Method getSelectedMethod() {
        return this.selectedMethod;
    }

    void updateMethodList() {
        this.methodModel.removeAllElements();
        Object obj = this.cls.getSelectedItem();
        try {
            ClassFile cf = null;
            if (!(obj instanceof String) && obj instanceof ClassLocator) {
                ClassLocator cl = (ClassLocator)obj;
                cf = SystemFacade.getInstance().getClassFile(cl);
            }
            if (cf != null) {
                List<Method> methods = cf.getMethods();
                for (int i = 0; i < methods.size(); ++i) {
                    Method method = methods.get(i);
                    Wrapper<Method> wrapper = new Wrapper<Method>();
                    wrapper.setContent(method);
                    wrapper.setDisplay(method.getSignatureLine());
                    this.methodModel.addElement(wrapper);
                }
            }
        }
        catch (Exception e) {
            SystemFacade.getInstance().handleException(e);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }
}

