/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import net.sf.rej.files.ClassIndex;
import net.sf.rej.files.ClassLocator;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.dialog.ClassChooseDialog;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.Field;
import net.sf.rej.util.Wrapper;

public class FieldChooseDialog
extends JDialog {
    private Action classChooserAction = new AbstractAction("..."){

        public void actionPerformed(ActionEvent e) {
            ClassIndex cpIndex = SystemFacade.getInstance().getClassIndex();
            ClassChooseDialog ccd = new ClassChooseDialog((Frame)MainWindow.getInstance(), cpIndex);
            ccd.invoke();
            ClassLocator cl = ccd.getSelected();
            if (cl != null) {
                FieldChooseDialog.this.clsModel.addElement(cl);
                FieldChooseDialog.this.cls.setSelectedItem(cl);
                FieldChooseDialog.this.updateFieldList();
            }
        }
    };
    private Container panel = this.getContentPane();
    private JLabel label = new JLabel("Select field", 0);
    private JLabel classCaption = new JLabel("Class: ");
    private JLabel methodCaption = new JLabel("Field: ");
    DefaultComboBoxModel clsModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel fieldModel = new DefaultComboBoxModel();
    JComboBox cls = new JComboBox(this.clsModel);
    private JButton clsButton = new JButton(this.classChooserAction);
    private JComboBox field = new JComboBox(this.fieldModel);
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    ClassLocator selectedClass = null;
    Field selectedField = null;

    public FieldChooseDialog(Frame frame, ClassLocator defaultClass) {
        super(frame, "Choose Field", true);
        this.clsModel.addElement(defaultClass);
        this.cls.setSelectedItem(defaultClass);
        this.updateFieldList();
        this.panel.setLayout(new GridBagLayout());
        this.field.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FieldChooseDialog.this.done();
                }
            }
        });
        this.cls.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FieldChooseDialog.this.updateFieldList();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FieldChooseDialog.this.done();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FieldChooseDialog.this.selectedClass = null;
                FieldChooseDialog.this.selectedField = null;
                FieldChooseDialog.this.setVisible(false);
            }
        });
        this.addCenter(this.label, 0, 0, 4);
        this.addEast(this.classCaption, 0, 1);
        this.addCenter(this.cls, 1, 1, 2);
        this.addCenter(this.clsButton, 3, 1, 1);
        this.addEast(this.methodCaption, 0, 2);
        this.addCenter(this.field, 1, 2, 3);
        this.addCenter(this.okButton, 0, 3, 2);
        this.addCenter(this.cancelButton, 2, 3, 2);
        this.pack();
    }

    private void addCenter(Component comp, int x, int y, int width) {
        this.panel.add(comp, new GridBagConstraints(x, y, width, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void addEast(Component comp, int x, int y) {
        this.panel.add(comp, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    public void invoke() {
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public void done() {
        this.selectedClass = (ClassLocator)this.cls.getSelectedItem();
        this.selectedField = null;
        Wrapper wrapper = (Wrapper)this.field.getSelectedItem();
        if (wrapper != null) {
            this.selectedField = (Field)wrapper.getContent();
        }
        this.setVisible(false);
    }

    public ClassLocator getSelectedClass() {
        return this.selectedClass;
    }

    public Field getSelectedField() {
        return this.selectedField;
    }

    void updateFieldList() {
        this.fieldModel.removeAllElements();
        Object obj = this.cls.getSelectedItem();
        try {
            ClassFile cf = null;
            if (!(obj instanceof String) && obj instanceof ClassLocator) {
                ClassLocator cl = (ClassLocator)obj;
                cf = SystemFacade.getInstance().getClassFile(cl);
            }
            if (cf != null) {
                List<Field> fields = cf.getFields();
                for (int i = 0; i < fields.size(); ++i) {
                    Field field = fields.get(i);
                    Wrapper<Field> wrapper = new Wrapper<Field>();
                    wrapper.setContent(field);
                    wrapper.setDisplay(field.getSignatureLine());
                    this.fieldModel.addElement(wrapper);
                }
            }
        }
        catch (Exception e) {
            SystemFacade.getInstance().handleException(e);
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }
}

