/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.rej.files.ClassIndex;
import net.sf.rej.files.ClassLocator;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.dialog.ClassChooseDialog;
import net.sf.rej.java.JavaType;

public class ExceptionChooseDialog
extends JDialog {
    private JPanel jContentPane = null;
    JList paramList = null;
    private JButton moveDownButton = null;
    private JPanel movePanel = null;
    private JButton moveUpButton = null;
    private JPanel addEditRemovePanel = null;
    private JPanel okCancelPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton addButton = null;
    private JButton editButton = null;
    private JButton removeButton = null;
    DefaultListModel model = new DefaultListModel();
    boolean cancelled = false;

    public ExceptionChooseDialog(Dialog owner) {
        super(owner, true);
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setTitle("Exception Chooser");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 1;
            gridBagConstraints1.gridy = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)new JScrollPane(this.getParamList()), gridBagConstraints);
            this.jContentPane.add((Component)this.getMovePanel(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getAddEditRemovePanel(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getOkCancelPanel(), gridBagConstraints3);
        }
        return this.jContentPane;
    }

    private JList getParamList() {
        if (this.paramList == null) {
            this.paramList = new JList(this.model);
        }
        return this.paramList;
    }

    private JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new JButton();
            this.moveDownButton.setText("Move Down");
            this.moveDownButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index;
                    JavaType jt = (JavaType)ExceptionChooseDialog.this.paramList.getSelectedValue();
                    if (jt != null && (index = ExceptionChooseDialog.this.paramList.getSelectedIndex()) < ExceptionChooseDialog.this.model.size() - 1) {
                        ExceptionChooseDialog.this.model.remove(index);
                        ExceptionChooseDialog.this.model.add(index + 1, jt);
                        ExceptionChooseDialog.this.paramList.setSelectedIndex(index + 1);
                    }
                }
            });
        }
        return this.moveDownButton;
    }

    private JPanel getMovePanel() {
        if (this.movePanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            gridLayout.setHgap(2);
            gridLayout.setVgap(5);
            gridLayout.setColumns(1);
            this.movePanel = new JPanel();
            this.movePanel.setLayout(gridLayout);
            this.movePanel.add((Component)this.getMoveUpButton(), null);
            this.movePanel.add((Component)this.getMoveDownButton(), null);
        }
        return this.movePanel;
    }

    private JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new JButton();
            this.moveUpButton.setText("Move Up");
            this.moveUpButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index;
                    JavaType jt = (JavaType)ExceptionChooseDialog.this.paramList.getSelectedValue();
                    if (jt != null && (index = ExceptionChooseDialog.this.paramList.getSelectedIndex()) > 0) {
                        ExceptionChooseDialog.this.model.remove(index);
                        ExceptionChooseDialog.this.model.add(index - 1, jt);
                        ExceptionChooseDialog.this.paramList.setSelectedIndex(index - 1);
                    }
                }
            });
        }
        return this.moveUpButton;
    }

    private JPanel getAddEditRemovePanel() {
        if (this.addEditRemovePanel == null) {
            this.addEditRemovePanel = new JPanel();
            this.addEditRemovePanel.add((Component)this.getAddButton(), null);
            this.addEditRemovePanel.add((Component)this.getEditButton(), null);
            this.addEditRemovePanel.add((Component)this.getRemoveButton(), null);
        }
        return this.addEditRemovePanel;
    }

    private JPanel getOkCancelPanel() {
        if (this.okCancelPanel == null) {
            this.okCancelPanel = new JPanel();
            this.okCancelPanel.add((Component)this.getOkButton(), null);
            this.okCancelPanel.add((Component)this.getCancelButton(), null);
        }
        return this.okCancelPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExceptionChooseDialog.this.cancelled = false;
                    ExceptionChooseDialog.this.setVisible(false);
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ExceptionChooseDialog.this.cancelled = true;
                    ExceptionChooseDialog.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add..");
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ClassIndex cpIndex = SystemFacade.getInstance().getClassIndex();
                    ClassChooseDialog ccd = new ClassChooseDialog((Dialog)ExceptionChooseDialog.this, cpIndex);
                    ccd.invoke();
                    ClassLocator cl = ccd.getSelected();
                    if (cl != null) {
                        ExceptionChooseDialog.this.model.addElement(cl.getFullName());
                    }
                }
            });
        }
        return this.addButton;
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit..");
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Object obj = ExceptionChooseDialog.this.paramList.getSelectedValue();
                    if (obj != null) {
                        int index = ExceptionChooseDialog.this.paramList.getSelectedIndex();
                        ClassIndex cpIndex = SystemFacade.getInstance().getClassIndex();
                        ClassChooseDialog ccd = new ClassChooseDialog((Dialog)ExceptionChooseDialog.this, cpIndex);
                        ccd.invoke();
                        ClassLocator cl = ccd.getSelected();
                        if (cl != null) {
                            ExceptionChooseDialog.this.model.remove(index);
                            ExceptionChooseDialog.this.model.add(index, cl.getFullName());
                        }
                        ExceptionChooseDialog.this.paramList.setSelectedIndex(index);
                    }
                }
            });
        }
        return this.editButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("Remove");
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Object obj = ExceptionChooseDialog.this.paramList.getSelectedValue();
                    if (obj != null) {
                        ExceptionChooseDialog.this.model.removeElement(obj);
                    }
                }
            });
        }
        return this.removeButton;
    }

    public void invoke(List params) {
        this.model.removeAllElements();
        for (int i = 0; i < params.size(); ++i) {
            this.model.addElement(params.get(i));
        }
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public List getExceptions() {
        return Arrays.asList(this.model.toArray());
    }
}

