/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.dialog;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.rej.files.ClassIndex;
import net.sf.rej.files.ClassLocator;
import net.sf.rej.gui.editor.OrderedFilterListModel;

public class ClassChooseDialog
extends JDialog {
    private JPanel panel = new JPanel();
    JLabel label = new JLabel("Select class");
    JTextField value = new JTextField(16);
    OrderedFilterListModel model = null;
    JList list = null;
    JLabel packageCaption = new JLabel("Package: ");
    JLabel packageLabel = new JLabel("");
    JButton okButton = new JButton("OK");
    JButton cancelButton = new JButton("Cancel");
    ClassLocator selectedValue = null;

    public ClassChooseDialog(Frame parent, ClassIndex classPathIndex) {
        super(parent, "Choose Class", true);
        this.initialize(classPathIndex);
        this.setLocationRelativeTo(parent);
    }

    public ClassChooseDialog(Dialog parent, ClassIndex classPathIndex) {
        super(parent, "Choose Class", true);
        this.initialize(classPathIndex);
        this.setLocationRelativeTo(parent);
    }

    private void initialize(ClassIndex classPathIndex) {
        List<ClassLocator> cpIndex = classPathIndex.getAll();
        this.model = new OrderedFilterListModel(cpIndex);
        this.model.setFilter(this.value.getText());
        this.model.filter();
        this.list = new JList(this.model);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent lse) {
                ClassChooseDialog.this.updatePackage();
            }
        });
        this.panel.setLayout(new GridBagLayout());
        this.value.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ClassChooseDialog.this.done();
                } else {
                    ClassChooseDialog.this.model.setFilter(ClassChooseDialog.this.value.getText());
                    ClassChooseDialog.this.model.filter();
                    ClassChooseDialog.this.list.setSelectedIndex(0);
                    ClassChooseDialog.this.updatePackage();
                }
            }
        });
        this.list.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ClassChooseDialog.this.done();
                }
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassChooseDialog.this.done();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassChooseDialog.this.selectedValue = null;
                ClassChooseDialog.this.setVisible(false);
            }
        });
        this.getContentPane().add(this.panel);
        this.addCenter(this.label, 0, 0, 2);
        this.addCenter(this.value, 0, 1, 2);
        this.addCenter(new JScrollPane(this.list), 0, 2, 2);
        this.addEast(this.packageCaption, 0, 3);
        this.addCenter(this.packageLabel, 1, 3);
        this.addCenter(this.okButton, 0, 4);
        this.addCenter(this.cancelButton, 1, 4);
        this.pack();
    }

    private void addCenter(Component comp, int x, int y) {
        this.panel.add(comp, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addCenter(Component comp, int x, int y, int width) {
        this.panel.add(comp, new GridBagConstraints(x, y, width, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addEast(Component comp, int x, int y) {
        this.panel.add(comp, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void invoke() {
        this.setModal(true);
        this.setVisible(true);
    }

    public void done() {
        this.selectedValue = (ClassLocator)this.list.getSelectedValue();
        if (this.selectedValue != null) {
            this.setVisible(false);
        }
    }

    public ClassLocator getSelected() {
        return this.selectedValue;
    }

    public void updatePackage() {
        ClassLocator cl;
        if (this.model.getSize() == 0) {
            this.packageLabel.setText("");
        }
        if ((cl = (ClassLocator)this.list.getSelectedValue()) != null) {
            this.packageLabel.setText(cl.getPackage());
        } else {
            this.packageLabel.setText("");
        }
    }
}

