/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.debug;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.StepRequest;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.rej.gui.EditorFacade;
import net.sf.rej.gui.debug.wrappers.StackFrameWrapper;
import net.sf.rej.gui.debug.wrappers.ThreadReferenceWrapper;
import net.sf.rej.gui.debug.wrappers.VirtualMachineWrapper;
import net.sf.rej.gui.editor.Breakpoint;
import net.sf.rej.gui.event.Event;
import net.sf.rej.gui.event.EventDispatcher;
import net.sf.rej.gui.event.EventObserver;
import net.sf.rej.gui.event.EventType;

public class VMEventHandler
implements Runnable,
EventObserver {
    private static final Logger logger = Logger.getLogger(VMEventHandler.class.getName());
    private VirtualMachine vm;
    private boolean interrupted = false;
    private EventDispatcher dispatcher = null;
    private boolean suspended = false;
    private ThreadReference currentThread = null;
    private boolean suspendOnStartup = false;

    public void setVM(VirtualMachine vm) {
        this.vm = vm;
    }

    public void setSuspendOnStartup(boolean suspendOnStartup) {
        this.suspendOnStartup = suspendOnStartup;
    }

    public void run() {
        block2: while (!this.interrupted) {
            try {
                EventSet es = this.vm.eventQueue().remove(2000L);
                if (es == null) continue;
                for (com.sun.jdi.event.Event event : es) {
                    if (event instanceof VMStartEvent) {
                        this.dispatcher.notifyObservers(new Event(EventType.DEBUG_ATTACH));
                        if (!this.suspendOnStartup) continue;
                        this.suspended = true;
                        Event evt = new Event(EventType.DEBUG_SUSPENDED);
                        evt.setVM(new VirtualMachineWrapper(this.vm));
                        this.dispatcher.notifyObservers(evt);
                        continue;
                    }
                    if (event instanceof VMDeathEvent) continue;
                    if (event instanceof VMDisconnectEvent) break block2;
                    if (event instanceof BreakpointEvent || event instanceof StepEvent) {
                        ThreadReference thread;
                        if (event instanceof BreakpointEvent) {
                            BreakpointEvent be = (BreakpointEvent)event;
                            thread = be.thread();
                        } else {
                            StepEvent se = (StepEvent)event;
                            thread = se.thread();
                            this.vm.eventRequestManager().deleteEventRequest(se.request());
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                Event event = new Event(EventType.DEBUG_SUSPENDED);
                                event.setVM(new VirtualMachineWrapper(VMEventHandler.this.vm));
                                VMEventHandler.this.dispatcher.notifyObservers(event);
                                event = new Event(EventType.DEBUG_THREAD_CHANGE_REQUESTED);
                                event.setThread(new ThreadReferenceWrapper(thread));
                                VMEventHandler.this.dispatcher.notifyObservers(event);
                                event = new Event(EventType.DEBUG_STACK_FRAME_CHANGE_REQUESTED);
                                try {
                                    event.setStackFrame(new StackFrameWrapper(thread.frame(0)));
                                }
                                catch (IncompatibleThreadStateException e) {
                                    e.printStackTrace();
                                }
                                VMEventHandler.this.dispatcher.notifyObservers(event);
                            }
                        });
                        continue;
                    }
                    if (!(event instanceof ClassPrepareEvent)) continue;
                    ClassPrepareEvent cpe = (ClassPrepareEvent)event;
                    for (Breakpoint bp : EditorFacade.getInstance().getBreakpoints()) {
                        if (!bp.getClassName().equals(cpe.referenceType().name())) continue;
                        List<Method> mlist = cpe.referenceType().methodsByName(bp.getMethodName(), bp.getMethodDesc().getRawDesc());
                        if (mlist.size() > 0) {
                            Location loc = mlist.get(0).locationOfCodeIndex(bp.getPc());
                            BreakpointRequest bpr = this.vm.eventRequestManager().createBreakpointRequest(loc);
                            bpr.setSuspendPolicy(2);
                            bpr.setEnabled(true);
                            continue;
                        }
                        logger.warning("Error, breakpoint " + bp + " method not found in EventHandler.");
                    }
                    this.vm.resume();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (this.interrupted) {
            this.vm.dispose();
        }
        this.dispatcher.notifyObservers(new Event(EventType.DEBUG_DETACH));
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    public void processEvent(Event event) {
        switch (event.getType()) {
            case INIT: {
                this.dispatcher = event.getDispatcher();
                break;
            }
            case DEBUG_RESUME_REQUESTED: {
                if (!this.suspended) break;
                this.vm.resume();
                this.dispatcher.notifyObservers(new Event(EventType.DEBUG_RESUMED));
                break;
            }
            case DEBUG_SUSPEND_REQUESTED: {
                if (this.suspended) break;
                this.vm.suspend();
                this.vm.eventRequestManager().deleteEventRequests(this.vm.eventRequestManager().stepRequests());
                Event evt = new Event(EventType.DEBUG_SUSPENDED);
                evt.setVM(new VirtualMachineWrapper(this.vm));
                this.dispatcher.notifyObservers(evt);
                break;
            }
            case DEBUG_RESUMED: {
                this.suspended = false;
                break;
            }
            case DEBUG_SUSPENDED: {
                this.suspended = true;
                break;
            }
            case DEBUG_THREAD_CHANGED: {
                this.currentThread = (ThreadReference)event.getThread().getThreadReferenceObject();
                break;
            }
            case DEBUG_STEP_INTO_REQUESTED: {
                StepRequest sr = this.vm.eventRequestManager().createStepRequest(this.currentThread, -1, 1);
                sr.setSuspendPolicy(2);
                sr.setEnabled(true);
                this.vm.resume();
                this.dispatcher.notifyObservers(new Event(EventType.DEBUG_RESUMED));
                break;
            }
            case DEBUG_STEP_OUT_REQUESTED: {
                StepRequest sr = this.vm.eventRequestManager().createStepRequest(this.currentThread, -1, 3);
                sr.setSuspendPolicy(2);
                sr.setEnabled(true);
                this.vm.resume();
                this.dispatcher.notifyObservers(new Event(EventType.DEBUG_RESUMED));
                break;
            }
            case DEBUG_STEP_OVER_REQUESTED: {
                StepRequest sr = this.vm.eventRequestManager().createStepRequest(this.currentThread, -1, 2);
                sr.setSuspendPolicy(2);
                sr.setEnabled(true);
                this.vm.resume();
                this.dispatcher.notifyObservers(new Event(EventType.DEBUG_RESUMED));
                break;
            }
        }
    }
}

