/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.debug;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.rej.gui.debug.wrappers.StackFrameWrapper;
import net.sf.rej.gui.debug.wrappers.ThreadReferenceWrapper;
import net.sf.rej.gui.event.Event;
import net.sf.rej.gui.event.EventDispatcher;
import net.sf.rej.gui.event.EventObserver;
import net.sf.rej.gui.event.EventType;
import net.sf.rej.util.Wrapper;

public class DebugControlPanel
extends JPanel
implements EventObserver {
    private static final long serialVersionUID = 1L;
    private JButton suspendButton = null;
    private JButton resumeButton = null;
    private JPanel statusPanel = null;
    private JLabel statusLabel = null;
    private JPanel stepPanel = null;
    private JButton stepOverButton = null;
    private JButton stepIntoButton = null;
    private JButton stepOutButton = null;
    private JPanel threadsPanel = null;
    private JPanel stackFramesPanel = null;
    private JScrollPane threadScrollPane = null;
    private JScrollPane stackFrameScrollPane = null;
    private JList threadList = null;
    private JList stackFrameList = null;
    private DefaultListModel threadModel;
    private DefaultListModel stackModel;
    private VirtualMachine vm = null;
    EventDispatcher dispatcher;
    private final Action debugResume = new AbstractAction("Resume"){

        public void actionPerformed(ActionEvent e) {
            DebugControlPanel.this.dispatcher.notifyObservers(new Event(EventType.DEBUG_RESUME_REQUESTED));
        }
    };
    private final Action debugSuspend = new AbstractAction("Suspend"){

        public void actionPerformed(ActionEvent e) {
            DebugControlPanel.this.dispatcher.notifyObservers(new Event(EventType.DEBUG_SUSPEND_REQUESTED));
        }
    };
    private final Action debugStepInto = new AbstractAction("Into"){

        public void actionPerformed(ActionEvent e) {
            DebugControlPanel.this.dispatcher.notifyObservers(new Event(EventType.DEBUG_STEP_INTO_REQUESTED));
        }
    };
    private final Action debugStepOver = new AbstractAction("Over"){

        public void actionPerformed(ActionEvent e) {
            DebugControlPanel.this.dispatcher.notifyObservers(new Event(EventType.DEBUG_STEP_OVER_REQUESTED));
        }
    };
    private final Action debugStepOut = new AbstractAction("Out"){

        public void actionPerformed(ActionEvent e) {
            DebugControlPanel.this.dispatcher.notifyObservers(new Event(EventType.DEBUG_STEP_OUT_REQUESTED));
        }
    };

    public DebugControlPanel() {
        this.initialize();
        this.setStatusAsRunning();
    }

    private void initialize() {
        GridBagConstraints threadsPanelConstraints = new GridBagConstraints();
        threadsPanelConstraints.gridx = 4;
        threadsPanelConstraints.gridy = 0;
        threadsPanelConstraints.weightx = 1.0;
        threadsPanelConstraints.weighty = 1.0;
        threadsPanelConstraints.fill = 1;
        GridBagConstraints stackFramesPanelConstraints = new GridBagConstraints();
        stackFramesPanelConstraints.gridx = 5;
        stackFramesPanelConstraints.gridy = 0;
        stackFramesPanelConstraints.weightx = 1.0;
        stackFramesPanelConstraints.weighty = 1.0;
        stackFramesPanelConstraints.fill = 1;
        GridBagConstraints stepPanelConstraints = new GridBagConstraints();
        stepPanelConstraints.gridx = 3;
        stepPanelConstraints.gridy = 0;
        GridBagConstraints statusPanelConstraints = new GridBagConstraints();
        statusPanelConstraints.gridx = 2;
        statusPanelConstraints.gridy = 0;
        GridBagConstraints resumeButtonConstraints = new GridBagConstraints();
        resumeButtonConstraints.gridx = 1;
        resumeButtonConstraints.gridy = 0;
        GridBagConstraints suspendButtonConstraints = new GridBagConstraints();
        suspendButtonConstraints.gridx = 0;
        suspendButtonConstraints.gridy = 0;
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getSuspendButton(), suspendButtonConstraints);
        this.add((Component)this.getResumeButton(), resumeButtonConstraints);
        this.add((Component)this.getStatusPanel(), statusPanelConstraints);
        this.add((Component)this.getStepPanel(), stepPanelConstraints);
        this.add((Component)this.getThreadsPanel(), threadsPanelConstraints);
        this.add((Component)this.getStackFramesPanel(), stackFramesPanelConstraints);
    }

    private JButton getSuspendButton() {
        if (this.suspendButton == null) {
            this.suspendButton = new JButton(this.debugSuspend);
        }
        return this.suspendButton;
    }

    private JButton getResumeButton() {
        if (this.resumeButton == null) {
            this.resumeButton = new JButton(this.debugResume);
        }
        return this.resumeButton;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusLabel = new JLabel();
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new GridBagLayout());
            this.statusPanel.setBorder(BorderFactory.createTitledBorder(null, "Status", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.statusPanel.add((Component)this.statusLabel, new GridBagConstraints());
        }
        return this.statusPanel;
    }

    private JPanel getStepPanel() {
        if (this.stepPanel == null) {
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 2;
            gridBagConstraints6.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            this.stepPanel = new JPanel();
            this.stepPanel.setLayout(new GridBagLayout());
            this.stepPanel.setBorder(BorderFactory.createTitledBorder(null, "Step..", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.stepPanel.add((Component)this.getStepOverButton(), gridBagConstraints4);
            this.stepPanel.add((Component)this.getStepIntoButton(), gridBagConstraints5);
            this.stepPanel.add((Component)this.getStepOutButton(), gridBagConstraints6);
        }
        return this.stepPanel;
    }

    private JButton getStepOverButton() {
        if (this.stepOverButton == null) {
            this.stepOverButton = new JButton(this.debugStepOver);
            this.stepOverButton.setText("Over");
        }
        return this.stepOverButton;
    }

    private JButton getStepIntoButton() {
        if (this.stepIntoButton == null) {
            this.stepIntoButton = new JButton(this.debugStepInto);
            this.stepIntoButton.setText("Into");
        }
        return this.stepIntoButton;
    }

    private JButton getStepOutButton() {
        if (this.stepOutButton == null) {
            this.stepOutButton = new JButton(this.debugStepOut);
            this.stepOutButton.setText("Out");
        }
        return this.stepOutButton;
    }

    private JPanel getThreadsPanel() {
        if (this.threadsPanel == null) {
            this.threadsPanel = new JPanel();
            this.threadsPanel.setLayout(new BorderLayout());
            this.threadsPanel.setBorder(BorderFactory.createTitledBorder(null, "Threads", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.threadsPanel.add((Component)this.getThreadScrollPane(), "Center");
        }
        return this.threadsPanel;
    }

    private JPanel getStackFramesPanel() {
        if (this.stackFramesPanel == null) {
            this.stackFramesPanel = new JPanel();
            this.stackFramesPanel.setLayout(new BorderLayout());
            this.stackFramesPanel.setBorder(BorderFactory.createTitledBorder(null, "Stack Frames", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.stackFramesPanel.add((Component)this.getStackFrameScrollPane(), "Center");
        }
        return this.stackFramesPanel;
    }

    private JScrollPane getThreadScrollPane() {
        if (this.threadScrollPane == null) {
            this.threadScrollPane = new JScrollPane();
            this.threadScrollPane.setViewportView(this.getThreadList());
        }
        return this.threadScrollPane;
    }

    private JScrollPane getStackFrameScrollPane() {
        if (this.stackFrameScrollPane == null) {
            this.stackFrameScrollPane = new JScrollPane();
            this.stackFrameScrollPane.setViewportView(this.getStackFrameList());
        }
        return this.stackFrameScrollPane;
    }

    private JList getThreadList() {
        if (this.threadList == null) {
            this.threadModel = new DefaultListModel();
            this.threadList = new JList(this.threadModel);
            this.threadList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    Object item = DebugControlPanel.this.threadList.getSelectedValue();
                    if (item != null && !item.equals("")) {
                        Wrapper wrapper = (Wrapper)item;
                        Event event = new Event(EventType.DEBUG_THREAD_CHANGED);
                        event.setThread(new ThreadReferenceWrapper((ThreadReference)wrapper.getContent()));
                        DebugControlPanel.this.dispatcher.notifyObservers(event);
                    }
                }
            });
        }
        return this.threadList;
    }

    private JList getStackFrameList() {
        if (this.stackFrameList == null) {
            this.stackModel = new DefaultListModel();
            this.stackFrameList = new JList(this.stackModel);
            this.stackFrameList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    Object item = DebugControlPanel.this.stackFrameList.getSelectedValue();
                    if (item != null && !item.equals("")) {
                        Wrapper wrapper = (Wrapper)item;
                        Event event = new Event(EventType.DEBUG_STACK_FRAME_CHANGED);
                        event.setStackFrame(new StackFrameWrapper((StackFrame)wrapper.getContent()));
                        DebugControlPanel.this.dispatcher.notifyObservers(event);
                    }
                }
            });
        }
        return this.stackFrameList;
    }

    public void processEvent(Event event) {
        switch (event.getType()) {
            case INIT: {
                this.dispatcher = event.getDispatcher();
                break;
            }
            case DEBUG_RESUMED: {
                this.setStatusAsRunning();
                this.threadModel.removeAllElements();
                this.stackModel.removeAllElements();
                break;
            }
            case DEBUG_SUSPENDED: {
                this.setStatusAsSuspended();
                this.vm = (VirtualMachine)event.getVM().getVirtualMachineObject();
                this.updateThreadList();
                break;
            }
            case DEBUG_THREAD_CHANGE_REQUESTED: {
                this.setSelectedThread((ThreadReference)event.getThread().getThreadReferenceObject());
                break;
            }
            case DEBUG_THREAD_CHANGED: {
                ThreadReference thread = (ThreadReference)event.getThread().getThreadReferenceObject();
                this.updateStackFrameList(thread);
                break;
            }
            case DEBUG_STACK_FRAME_CHANGE_REQUESTED: {
                this.setSelectedStackFrame((StackFrame)event.getStackFrame().getStackFrameObject());
                break;
            }
            case DEBUG_STACK_FRAME_CHANGED: {
                break;
            }
        }
    }

    private void setStatusAsRunning() {
        this.statusLabel.setText("Running");
        this.statusLabel.setForeground(Color.GREEN.darker());
        this.resumeButton.setEnabled(false);
        this.stepIntoButton.setEnabled(false);
        this.stepOutButton.setEnabled(false);
        this.stepOverButton.setEnabled(false);
        this.suspendButton.setEnabled(true);
    }

    private void setStatusAsSuspended() {
        this.statusLabel.setText("Suspended");
        this.statusLabel.setForeground(Color.RED.darker());
        this.resumeButton.setEnabled(true);
        this.stepIntoButton.setEnabled(true);
        this.stepOutButton.setEnabled(true);
        this.stepOverButton.setEnabled(true);
        this.suspendButton.setEnabled(false);
    }

    private void updateThreadList() {
        this.threadModel.removeAllElements();
        for (ThreadReference thread : this.vm.allThreads()) {
            Wrapper<ThreadReference> wrapper = new Wrapper<ThreadReference>();
            wrapper.setContent(thread);
            wrapper.setDisplay(thread.name());
            this.threadModel.addElement(wrapper);
        }
    }

    private void updateStackFrameList(ThreadReference thread) {
        this.stackModel.removeAllElements();
        try {
            for (StackFrame sf : thread.frames()) {
                Wrapper<StackFrame> wrapper = new Wrapper<StackFrame>();
                wrapper.setContent(sf);
                wrapper.setDisplay(sf.location().method() + ":" + sf.location().codeIndex());
                this.stackModel.addElement(wrapper);
            }
        }
        catch (IncompatibleThreadStateException ite) {
            ite.printStackTrace();
        }
    }

    private void setSelectedThread(ThreadReference thread) {
        for (int i = 0; i < this.threadModel.size(); ++i) {
            Wrapper wrapper = (Wrapper)this.threadModel.get(i);
            if (!((ThreadReference)wrapper.getContent()).equals(thread)) continue;
            this.threadList.setSelectedValue(wrapper, true);
        }
    }

    private void setSelectedStackFrame(StackFrame frame) {
        for (int i = 0; i < this.stackModel.size(); ++i) {
            Wrapper wrapper = (Wrapper)this.stackModel.get(i);
            if (!((StackFrame)wrapper.getContent()).equals(frame)) continue;
            this.stackFrameList.setSelectedValue(wrapper, true);
        }
    }
}

