/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.compare;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sf.rej.files.FileSet;
import net.sf.rej.files.SingleFile;
import net.sf.rej.gui.ProgressMonitor;
import net.sf.rej.gui.SystemFacade;
import net.sf.rej.gui.compare.FileItem;
import net.sf.rej.gui.compare.PackageItem;
import net.sf.rej.gui.compare.Style;
import net.sf.rej.util.IOToolkit;
import net.sf.rej.util.StopWatch;

public class CompareThread
implements Runnable {
    private FileSet filesetA;
    private FileSet filesetB;
    private List<String> listA;
    private List<String> listB;
    private DefaultMutableTreeNode root;
    private JTree tree;

    public CompareThread(FileSet a1, FileSet a2, JTree tree, DefaultMutableTreeNode root) {
        this.filesetA = a1;
        this.filesetB = a2;
        this.tree = tree;
        this.root = root;
        this.listA = a1.getContentsList();
        this.listB = a2.getContentsList();
    }

    public void run() {
        try {
            this.root.removeAllChildren();
            if (this.filesetA instanceof SingleFile && this.filesetB instanceof SingleFile && !((Object)this.listA).equals(this.listB)) {
                FileItem fileItem = new FileItem(this.filesetA.getName(), this.filesetB.getName(), this.filesetA.getName(), this.filesetB.getName());
                DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(fileItem);
                this.root.add(fileNode);
                InputStream isA = this.filesetA.getInputStream(this.filesetA.getName());
                InputStream isB = this.filesetB.getInputStream(this.filesetB.getName());
                boolean eq = IOToolkit.areEqual(isA, isB);
                isA.close();
                isB.close();
                if (eq) {
                    fileItem.setStyle(Style.PLAIN);
                } else {
                    fileItem.setStyle(Style.RED_AND_YELLOW);
                }
                this.tree.expandPath(this.tree.getPathForRow(0));
                return;
            }
            StopWatch watch = new StopWatch();
            SystemFacade.getInstance().setStatus("Preparing comparison.");
            ProgressMonitor pm = SystemFacade.getInstance().getProgressMonitor();
            final TreeSet<String> pkgsAll = new TreeSet<String>();
            TreeSet<String> pkgsA = new TreeSet<String>();
            for (String contentFile : this.listA) {
                int index = contentFile.lastIndexOf(47);
                if (index == -1) {
                    pkgsAll.add("");
                    pkgsA.add("");
                    continue;
                }
                String pkg = contentFile.substring(0, index);
                pkgsAll.add(pkg);
                pkgsA.add(pkg);
            }
            TreeSet<String> pkgsB = new TreeSet<String>();
            for (String contentFile : this.listB) {
                int index = contentFile.lastIndexOf(47);
                if (index == -1) {
                    pkgsAll.add("");
                    pkgsB.add("");
                    continue;
                }
                String pkg = contentFile.substring(0, index);
                pkgsAll.add(pkg);
                pkgsB.add(pkg);
            }
            HashMap<String, DefaultMutableTreeNode> map = new HashMap<String, DefaultMutableTreeNode>();
            for (String pkg : pkgsAll) {
                PackageItem pkgItem = new PackageItem(pkg);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(pkgItem);
                this.root.add(node);
                map.put(pkg, node);
                if (!pkgsA.contains(pkg)) {
                    pkgItem.setStyle(Style.YELLOW);
                    continue;
                }
                if (!pkgsB.contains(pkg)) {
                    pkgItem.setStyle(Style.RED);
                    continue;
                }
                pkgItem.setStyle(Style.PLAIN);
            }
            TreeSet<String> contentFileSet = new TreeSet<String>();
            contentFileSet.addAll(this.listA);
            contentFileSet.addAll(this.listB);
            pm.setProgressScope(0, contentFileSet.size());
            int progress = 0;
            for (String contentFile : contentFileSet) {
                SystemFacade.getInstance().setStatus("Comparing " + contentFile);
                pm.setProgress(progress++);
                int index = contentFile.lastIndexOf(47);
                String pkg = "";
                if (index != -1) {
                    pkg = contentFile.substring(0, index);
                }
                DefaultMutableTreeNode pkgNode = (DefaultMutableTreeNode)map.get(pkg);
                PackageItem pkgItem = (PackageItem)pkgNode.getUserObject();
                FileItem fileItem = null;
                fileItem = index == -1 ? new FileItem(contentFile, contentFile) : new FileItem(contentFile.substring(pkg.length() + 1), contentFile);
                DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(fileItem);
                pkgNode.add(fileNode);
                if (!this.listA.contains(contentFile)) {
                    fileItem.setStyle(Style.YELLOW);
                    if (pkgItem.getStyle() != Style.PLAIN) continue;
                    pkgItem.setStyle(Style.RED_AND_YELLOW);
                    continue;
                }
                if (!this.listB.contains(contentFile)) {
                    fileItem.setStyle(Style.RED);
                    if (pkgItem.getStyle() != Style.PLAIN) continue;
                    pkgItem.setStyle(Style.RED_AND_YELLOW);
                    continue;
                }
                InputStream isA = this.filesetA.getInputStream(contentFile);
                InputStream isB = this.filesetB.getInputStream(contentFile);
                boolean eq = IOToolkit.areEqual(isA, isB);
                isA.close();
                isB.close();
                if (eq) {
                    fileItem.setStyle(Style.PLAIN);
                    continue;
                }
                fileItem.setStyle(Style.RED_AND_YELLOW);
                pkgItem.setStyle(Style.RED_AND_YELLOW);
            }
            pm.setProgress(progress);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CompareThread.this.tree.expandPath(CompareThread.this.tree.getPathForRow(0));
                    if (pkgsAll.size() == 1) {
                        CompareThread.this.tree.expandPath(CompareThread.this.tree.getPathForRow(1));
                    }
                }
            });
            SystemFacade.getInstance().setStatus("Compare done in " + watch.elapsedSeconds() + " seconds.");
        }
        catch (Exception ee) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SystemFacade.getInstance().handleException(ee);
                }
            });
        }
    }
}

