/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.action;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.gui.Undoable;
import net.sf.rej.java.Field;
import net.sf.rej.java.constantpool.ConstantPool;

public class RenameFieldAction
implements Undoable {
    private ConstantPool cp;
    private Field field;
    private String fieldName;
    private int oldNameIndex;
    private List<Integer> createdPoolItems = new ArrayList<Integer>();

    public RenameFieldAction(ConstantPool pool, Field field, String name) {
        this.cp = pool;
        this.field = field;
        this.fieldName = name;
        this.oldNameIndex = field.getNameIndex();
    }

    public void execute() {
        int nameIndex = this.cp.indexOfUtf8(this.fieldName);
        if (nameIndex == -1) {
            nameIndex = this.cp.optionalAddUtf8(this.fieldName);
            this.createdPoolItems.add(nameIndex);
        }
        this.field.setNameIndex(nameIndex);
    }

    public void undo() {
        for (int i = 0; i < this.createdPoolItems.size(); ++i) {
            this.cp.removeLast();
        }
        this.field.setNameIndex(this.oldNameIndex);
    }
}

