/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.action;

import net.sf.rej.gui.Undoable;
import net.sf.rej.java.AccessFlags;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.Field;
import net.sf.rej.java.constantpool.ConstantPool;

public class ModifyFieldAction
implements Undoable {
    private ConstantPool cp;
    private Field field;
    private String fieldName;
    private Descriptor desc;
    private AccessFlags flags;
    private AccessFlags oldFlags;
    private int oldNameIndex;
    private int oldDescIndex;
    private int createdNameIndex = -1;
    private int createdDescIndex = -1;

    public ModifyFieldAction(ConstantPool pool, Field field, String name, Descriptor desc, AccessFlags accessFlags) {
        this.cp = pool;
        this.field = field;
        this.fieldName = name;
        this.desc = desc;
        this.flags = accessFlags;
        this.oldFlags = new AccessFlags(field.getAccessFlags());
        this.oldNameIndex = field.getNameIndex();
        this.oldDescIndex = field.getDescriptorIndex();
    }

    public void execute() {
        int nameIndex = this.cp.indexOfUtf8(this.fieldName);
        if (nameIndex == -1) {
            this.createdNameIndex = nameIndex = this.cp.optionalAddUtf8(this.fieldName);
        }
        this.field.setNameIndex(nameIndex);
        int descIndex = this.cp.indexOfUtf8(this.desc.getRawDesc());
        if (descIndex == -1) {
            this.createdDescIndex = descIndex = this.cp.optionalAddUtf8(this.desc.getRawDesc());
        }
        this.field.setDescriptorIndex(descIndex);
        this.field.setAccessFlags(this.flags);
    }

    public void undo() {
        if (this.createdDescIndex != -1) {
            this.cp.removeLast();
        }
        if (this.createdNameIndex != -1) {
            this.cp.removeLast();
        }
        this.field.setNameIndex(this.oldNameIndex);
        this.field.setDescriptorIndex(this.oldDescIndex);
        this.field.setAccessFlags(this.oldFlags);
    }
}

