/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.action;

import java.util.ArrayList;
import java.util.List;
import net.sf.rej.gui.Undoable;
import net.sf.rej.java.Descriptor;
import net.sf.rej.java.constantpool.ClassInfo;
import net.sf.rej.java.constantpool.ConstantPool;

public class ModifyClassInfoAction
implements Undoable {
    private ConstantPool cp;
    private ClassInfo info;
    private String value;
    private int oldNameIndex;
    private List<Integer> createdPoolItems = new ArrayList<Integer>();

    public ModifyClassInfoAction(ConstantPool cp, ClassInfo info, String newName) {
        this.cp = cp;
        this.info = info;
        this.value = Descriptor.arrayTypeToRaw(newName);
        this.oldNameIndex = info.getNameIndex();
    }

    public void execute() {
        int nameIndex = this.cp.indexOfUtf8(this.value);
        if (nameIndex == -1) {
            nameIndex = this.cp.optionalAddUtf8(this.value);
            this.createdPoolItems.add(nameIndex);
        }
        this.info.setNameIndex(nameIndex);
    }

    public void undo() {
        for (int i = 0; i < this.createdPoolItems.size(); ++i) {
            this.cp.removeLast();
        }
        this.info.setNameIndex(this.oldNameIndex);
    }
}

