/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui.action;

import net.sf.rej.gui.Undoable;
import net.sf.rej.java.constantpool.ConstantPool;
import net.sf.rej.java.instruction.Instruction;
import net.sf.rej.java.instruction.Parameters;

public class AddMethodRefAction
implements Undoable {
    private String className;
    private String methodName;
    private String typeName;
    private Instruction instruction;
    private int paramIndex;
    private ConstantPool pool;
    private int createdNameAndTypeIndex = -1;
    private int createdClassIndex = -1;
    private int createdRefIndex = -1;
    private int originalParamValue = -1;

    public AddMethodRefAction(String className, String methodName, String typeName, Instruction instruction, int i, ConstantPool pool) {
        this.className = className;
        this.methodName = methodName;
        this.typeName = typeName;
        this.instruction = instruction;
        this.paramIndex = i;
        this.pool = pool;
    }

    public void execute() {
        int index = this.pool.indexOfNameAndTypeRef(this.methodName, this.typeName);
        if (index == -1) {
            this.createdNameAndTypeIndex = this.pool.optionalAddNameAndTypeRef(this.methodName, this.typeName);
        }
        if ((index = this.pool.indexOfClassRef(this.className)) == -1) {
            this.createdClassIndex = this.pool.optionalAddClassRef(this.className);
        }
        if ((index = this.pool.indexOfMethodRef(this.className, this.methodName, this.typeName)) == -1) {
            index = this.createdRefIndex = this.pool.optionalAddMethodRef(this.className, this.methodName, this.typeName);
        }
        Parameters params = this.instruction.getParameters();
        this.originalParamValue = params.getInt(this.paramIndex);
        params.setValue(this.paramIndex, index);
        this.instruction.setParameters(params);
    }

    public void undo() {
        if (this.createdRefIndex != -1) {
            this.pool.removeLast();
        }
        if (this.createdClassIndex != -1) {
            this.pool.removeLast();
        }
        if (this.createdNameAndTypeIndex != -1) {
            this.pool.removeLast();
        }
        Parameters params = this.instruction.getParameters();
        params.setValue(this.paramIndex, this.originalParamValue);
        this.instruction.setParameters(params);
    }
}

