/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.gui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.rej.ProjectIterator;
import net.sf.rej.files.Archive;
import net.sf.rej.files.ClassIndex;
import net.sf.rej.files.ClassLocator;
import net.sf.rej.files.FileSet;
import net.sf.rej.files.Folder;
import net.sf.rej.files.Project;
import net.sf.rej.files.SingleFile;
import net.sf.rej.gui.IteratorAgent;
import net.sf.rej.gui.Link;
import net.sf.rej.gui.MainWindow;
import net.sf.rej.gui.ProgressMonitor;
import net.sf.rej.gui.UndoManager;
import net.sf.rej.gui.Undoable;
import net.sf.rej.gui.action.GroupAction;
import net.sf.rej.gui.action.MarkClassFileModifiedAction;
import net.sf.rej.gui.action.RemoveFileAction;
import net.sf.rej.gui.dialog.PreferencesDialog;
import net.sf.rej.gui.editor.RecentFiles;
import net.sf.rej.gui.event.Event;
import net.sf.rej.gui.event.EventDispatcher;
import net.sf.rej.gui.event.EventObserver;
import net.sf.rej.gui.event.EventType;
import net.sf.rej.gui.preferences.Preferences;
import net.sf.rej.gui.tab.Tab;
import net.sf.rej.java.ClassFactory;
import net.sf.rej.java.ClassFile;
import net.sf.rej.java.ClassParsingException;
import net.sf.rej.java.Disassembler;
import net.sf.rej.java.MethodFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemFacade
implements EventObserver {
    private static SystemFacade instance = null;
    private RecentFiles recent = new RecentFiles(new File("rej.recentfiles"));
    private Preferences preferences = new Preferences();
    private PreferencesDialog preferencesDialog = new PreferencesDialog(MainWindow.getInstance());
    ClassIndex classIndex = new ClassIndex();
    private ClassFactory classFactory = new ClassFactory();
    private MethodFactory methodFactory = new MethodFactory();
    private Project project = null;
    private String openFile = null;
    private EventDispatcher dispatcher = null;
    private ProgressMonitor progressMonitor = new ProgressMonitor(){

        public void setProgress(int progressPct) {
            SystemFacade.this.setProgress(progressPct);
        }

        public void setProgressScope(int min, int max) {
            SystemFacade.this.setProgressScope(min, max);
        }
    };

    private SystemFacade() {
        this.init();
    }

    private void init() {
        try {
            this.recent.load();
            this.preferences.setFile(new File("rej.preferences"));
            this.preferences.load();
            List<File> list = this.preferences.getClassPathList();
            for (int i = 0; i < list.size(); ++i) {
                File file = list.get(i);
                FileSet fs = this.getFileSet(file);
                this.classIndex.addElement(fs);
            }
            this.updateClassIndex();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public static synchronized SystemFacade getInstance() {
        if (instance == null) {
            instance = new SystemFacade();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPreferencesDialog() {
        try {
            FileSet fs;
            File file;
            int i;
            List<File> prevList = this.preferences.getClassPathList();
            this.preferencesDialog.setClasspathList(prevList);
            this.preferencesDialog.invoke();
            List<File> curList = this.preferencesDialog.getClasspathList();
            Preferences preferences = this.preferences;
            synchronized (preferences) {
                this.preferences.setClassPathList(curList);
                this.preferences.save();
            }
            ArrayList<File> newItems = new ArrayList<File>();
            newItems.addAll(curList);
            newItems.removeAll(prevList);
            ArrayList<File> removedItems = new ArrayList<File>();
            removedItems.addAll(prevList);
            removedItems.removeAll(curList);
            for (i = 0; i < removedItems.size(); ++i) {
                file = (File)removedItems.get(i);
                fs = this.getFileSet(file);
                this.classIndex.removeElement(fs);
            }
            for (i = 0; i < newItems.size(); ++i) {
                file = (File)newItems.get(i);
                fs = this.getFileSet(file);
                this.classIndex.addElement(fs);
            }
            this.updateClassIndex();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void exit() {
        if (this.project != null && this.project.isModified()) {
            int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), "There are unsaved changes, quit without saving changes?", "Unsaved changes.", 0, 3, null, new String[]{"Quit without saving", "Cancel"}, "Cancel");
            if (answer == 0) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    public void openFile(File f) {
        if (this.project != null) {
            this.classIndex.removeElement(this.project.getFileSet());
        }
        Project project = new Project();
        project.setFile(f);
        try {
            FileSet set = this.getFileSet(f);
            this.classIndex.addElement(set);
            this.updateClassIndex();
            project.setFileSet(set);
            this.openProject(project);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void openProject(Project project) {
        try {
            if (this.project != null) {
                Event closeEvent = new Event(EventType.PROJECT_UPDATE);
                this.dispatcher.notifyObservers(closeEvent);
            }
            Event event = new Event(EventType.PROJECT_UPDATE);
            event.setProject(project);
            this.dispatcher.notifyObservers(event);
            Event fileEvent = new Event(EventType.CLASS_OPEN);
            if (project.getFileSet() instanceof SingleFile) {
                fileEvent.setFile(project.getFile().getName());
                fileEvent.setClassFile(project.getClassFile(project.getFile().getName()));
            }
            this.dispatcher.notifyObservers(fileEvent);
            if (project.getFileSet() instanceof SingleFile) {
                MainWindow.getInstance().setTab(Tab.EDITOR);
            } else {
                MainWindow.getInstance().setTab(Tab.FILES);
            }
            this.setTitle();
            this.recent.add(project.getFile().getPath());
            MainWindow.getInstance().updateRecentFilesMenu();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void saveFile() {
        try {
            this.project.save();
            this.setTitle();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void saveFile(File file) {
        try {
            this.project.saveAs(file);
            this.setTitle();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void setProgress(int i) {
        MainWindow.getInstance().setProgress(i);
    }

    public void setProgressScope(int min, int max) {
        MainWindow.getInstance().setProgressScope(min, max);
    }

    public void setStatus(final String status) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainWindow.getInstance().setStatus(status);
            }
        });
    }

    public void handleException(Exception ex) {
        try {
            MainWindow mw = MainWindow.getInstance();
            if (mw != null) {
                mw.setStatus("Last exception: " + ex.getMessage());
                MainWindow.getInstance().showErrorMessage("Exception was thrown: " + ex.getMessage());
                ex.printStackTrace();
            } else {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handleExceptions(List errors) {
        try {
            for (Exception ex : errors) {
                MainWindow.getInstance().setStatus("Last exception: " + ex.getMessage());
                MainWindow.getInstance().showErrorMessage("Exception was thrown: " + ex.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FileSet getFileSet(File f) throws IOException {
        if (f.getName().endsWith(".class")) {
            return new SingleFile(f);
        }
        if (f.isDirectory()) {
            return new Folder(f);
        }
        if (f.getName().endsWith(".zip") || f.getName().endsWith(".jar")) {
            return new Archive(f);
        }
        throw new RuntimeException("File of wrong type: " + f.getName());
    }

    public void setTitle(String title) {
        MainWindow.getInstance().setTitle(title);
    }

    public void setTitle() {
        if (this.project.isModified()) {
            this.setTitle("reJ - *" + this.project.getFile().getPath());
        } else {
            this.setTitle("reJ - " + this.project.getFile().getPath());
        }
    }

    public void performAction(Undoable action) {
        this.performAction(action, this.openFile);
    }

    public void performAction(Undoable action, String targetFile) {
        try {
            UndoManager um = this.project.getUndoManager(targetFile);
            if (!this.project.isModified(targetFile)) {
                GroupAction ga = new GroupAction();
                ga.add(action);
                ClassFile cf = this.getClassFile(targetFile);
                ga.add(new MarkClassFileModifiedAction(this.project, targetFile, cf));
                um.add(ga);
                ga.execute();
            } else {
                um.add(action);
                action.execute();
            }
            this.dispatcher.notifyObservers(new Event(EventType.CLASS_UPDATE));
            this.setTitle();
        }
        catch (Exception e) {
            this.handleException(e);
            throw new RuntimeException(e);
        }
    }

    public void performProjectAction(Undoable action) {
        try {
            UndoManager um = this.project.getProjectUndoManager();
            um.add(action);
            action.execute();
            Event event = new Event(EventType.PROJECT_UPDATE);
            event.setProject(this.project);
            this.dispatcher.notifyObservers(event);
            this.setTitle();
        }
        catch (Exception e) {
            this.handleException(e);
            throw new RuntimeException(e);
        }
    }

    public void performUndo(String targetFile) {
        try {
            UndoManager um = this.project.getUndoManager(targetFile);
            um.undo();
            this.dispatcher.notifyObservers(new Event(EventType.CLASS_UPDATE));
            this.setTitle();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void performRedo(String targetFile) {
        try {
            UndoManager um = this.project.getUndoManager(targetFile);
            um.redo();
            this.dispatcher.notifyObservers(new Event(EventType.CLASS_UPDATE));
            this.setTitle();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void performProjectUndo() {
        try {
            UndoManager um = this.project.getProjectUndoManager();
            um.undo();
            Event event = new Event(EventType.PROJECT_UPDATE);
            event.setProject(this.project);
            this.dispatcher.notifyObservers(event);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void performProjectRedo() {
        try {
            UndoManager um = this.project.getProjectUndoManager();
            um.redo();
            Event event = new Event(EventType.PROJECT_UPDATE);
            event.setProject(this.project);
            this.dispatcher.notifyObservers(event);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void performFind() {
        try {
            throw new RuntimeException("Find operation not implmented.");
        }
        catch (Exception e) {
            this.handleException(e);
            return;
        }
    }

    public void removeFile(List<String> files) {
        try {
            RemoveFileAction rfa = new RemoveFileAction(this.project, files);
            this.performProjectAction(rfa);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public List getRecentFiles() {
        return this.recent.getList();
    }

    public void goTo(Link link) {
        if (link.getFile() != null && !link.getFile().equals(this.openFile)) {
            Event event = new Event(EventType.CLASS_OPEN);
            try {
                ClassFile cf = this.project.getClassFile(link.getFile());
                event.setClassFile(cf);
                event.setFile(link.getFile());
                this.dispatcher.notifyObservers(event);
            }
            catch (Exception ex) {
                SystemFacade.getInstance().handleException(ex);
            }
        }
        MainWindow.getInstance().setTab(link.getTab());
        MainWindow.getInstance().getSelectedTab().goTo(link);
    }

    public void search(IteratorAgent matcher) {
        ProjectIterator.iterate(this.project, matcher);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public ClassFile getClassFile(String filename) throws IOException, ClassParsingException {
        return this.project.getClassFile(filename);
    }

    public ClassFile getClassFile(ClassLocator classLocator) throws IOException, ClassParsingException {
        FileSet projectFileSet = this.project.getFileSet();
        if (projectFileSet.equals(classLocator.getFileSet())) {
            return this.getClassFile(classLocator.getFile());
        }
        try {
            byte[] data = classLocator.getFileSet().getData(classLocator.getFile());
            ClassFile cf = Disassembler.readClass(data);
            return cf;
        }
        catch (Exception e) {
            throw new ClassParsingException("Error opening file " + classLocator.dumpDetails(), e);
        }
    }

    public ClassIndex getClassIndex() {
        return this.classIndex;
    }

    public void updateClassIndex() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                SystemFacade.this.classIndex.conditionalUpdate();
            }
        });
        thread.start();
    }

    public void createNewArchiveProject(File archiveFile) {
        int answer;
        if (archiveFile.exists() && (answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), "File already exists. Overwrite?", "File already exists.", 0, 3, null, new String[]{"Overwrite", "Cancel"}, "Cancel")) != 0) {
            return;
        }
        try {
            Archive archive = Archive.createNew(archiveFile);
            Project project = new Project();
            project.setFile(archiveFile);
            project.setFileSet(archive);
            project.save();
            this.openProject(project);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void createNewClass(String fullClassName, String selectedFile) {
        ClassFile cf = this.classFactory.createClass(fullClassName);
        this.project.addFile(selectedFile, cf);
        Event event = new Event(EventType.PROJECT_UPDATE);
        event.setProject(this.project);
        this.dispatcher.notifyObservers(event);
        event = new Event(EventType.CLASS_OPEN);
        event.setClassFile(cf);
        event.setFile(selectedFile);
        this.dispatcher.notifyObservers(event);
    }

    public MethodFactory getMethodFactory() {
        return this.methodFactory;
    }

    @Override
    public void processEvent(Event event) {
        switch (event.getType()) {
            case INIT: {
                this.dispatcher = event.getDispatcher();
                break;
            }
            case PROJECT_UPDATE: {
                this.project = event.getProject();
                break;
            }
            case CLASS_OPEN: {
                this.openFile = event.getFile();
                break;
            }
        }
    }

    public Preferences getPreferences() {
        return this.preferences;
    }
}

