/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.rej.files.FileSet;
import net.sf.rej.files.Modifications;
import net.sf.rej.util.FileToolkit;
import net.sf.rej.util.IOToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleFile
extends FileSet {
    private File f;
    private List<InputStream> streams = new ArrayList<InputStream>();

    public SingleFile(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getName());
        }
        this.f = f;
    }

    private SingleFile() {
    }

    @Override
    public long getLength(String file) {
        return this.f.length();
    }

    @Override
    public InputStream getInputStream(String file) {
        try {
            FileInputStream fis = new FileInputStream(this.f);
            this.streams.add(fis);
            return fis;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.f.getName();
    }

    @Override
    public byte[] getData(String file) throws IOException {
        return FileToolkit.readBytes(this.f);
    }

    @Override
    public List<String> getContentsList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.f.getName());
        return list;
    }

    public void write(byte[] data) throws IOException {
        FileToolkit.writeBytes(this.f, data);
    }

    public void write(InputStream is) throws IOException {
        FileOutputStream fos = new FileOutputStream(this.f);
        IOToolkit.writeStream(is, fos);
        fos.flush();
        fos.close();
    }

    @Override
    public void close() {
        for (InputStream is : this.streams) {
            try {
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void removeFile(String filename) {
    }

    @Override
    public void addFile(String filename) {
    }

    @Override
    public void refresh() {
    }

    @Override
    public void save(Modifications ms) throws IOException {
        if (ms.isModified(this.getName())) {
            this.write(ms.getData(this.getName()));
        }
    }

    @Override
    public void saveAs(File file, Modifications ms) throws IOException {
        if (ms.isModified(this.getName())) {
            this.f = file;
            this.write(ms.getData(this.getName()));
        } else {
            byte[] data = this.getData(this.getName());
            this.f = file;
            this.write(data);
        }
    }

    public void partialSave(String filename, byte[] data) throws IOException {
        this.write(data);
    }

    @Override
    public void removeAllFiles() {
    }

    public static SingleFile createNew(File file) throws IOException {
        SingleFile sf = new SingleFile();
        sf.f = file;
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        file.createNewFile();
        return sf;
    }

    @Override
    public String getClasspath(String mainClass) {
        String[] packageElements = mainClass.split("\\.");
        File root = this.f;
        for (int i = 0; i < packageElements.length; ++i) {
            root = root.getParentFile();
        }
        return root.getPath();
    }
}

