/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.rej.files.FileSet;
import net.sf.rej.files.Modifications;
import net.sf.rej.util.FileToolkit;
import net.sf.rej.util.IOToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Folder
extends FileSet {
    private File f;
    private List<String> contents = null;

    public Folder(File f) throws IOException {
        this.f = f;
        if (!f.exists()) {
            throw new FileNotFoundException(f.getName());
        }
        this.refresh();
    }

    private Folder() {
    }

    @Override
    public long getLength(String file) {
        return this.getTarget(file).length();
    }

    public File getTarget(String file) {
        return new File(this.f, file);
    }

    @Override
    public InputStream getInputStream(String file) {
        try {
            return new FileInputStream(this.getTarget(file));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.f.getName();
    }

    @Override
    public byte[] getData(String file) throws IOException {
        return FileToolkit.readBytes(this.getTarget(file));
    }

    @Override
    public List<String> getContentsList() {
        ArrayList<String> contents = new ArrayList<String>();
        contents.addAll(this.contents);
        return contents;
    }

    public static void addTraversal(String base, File file, List<String> al) {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                al.add(base + "/" + files[i].getName());
                continue;
            }
            if (base.length() == 0) {
                Folder.addTraversal(files[i].getName(), files[i], al);
                continue;
            }
            Folder.addTraversal(base + "/" + files[i].getName(), files[i], al);
        }
    }

    public void startSerialization() {
    }

    public void write(String filename, byte[] data) throws IOException {
        this.write(this.getTarget(filename), data);
    }

    public void write(File file, byte[] data) throws IOException {
        FileToolkit.writeBytes(file, data);
    }

    public void finishSerialization() {
    }

    public void write(String filename, InputStream is) throws IOException {
        this.write(this.getTarget(filename), is);
    }

    public void write(File file, InputStream is) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        IOToolkit.writeStream(is, fos);
        fos.flush();
        fos.close();
    }

    @Override
    public void close() {
    }

    @Override
    public void removeFile(String filename) {
        this.contents.remove(filename);
    }

    @Override
    public void addFile(String filename) {
        this.getTarget(filename).getParentFile().mkdirs();
        this.contents.add(filename);
    }

    @Override
    public void refresh() {
        this.contents = new ArrayList<String>();
        Folder.addTraversal("", this.f, this.contents);
    }

    @Override
    public void save(Modifications mods) throws IOException {
        for (int i = 0; i < this.contents.size(); ++i) {
            String filename = this.contents.get(i);
            if (!mods.isModified(filename)) continue;
            byte[] data = mods.getData(filename);
            this.write(filename, data);
        }
    }

    @Override
    public void saveAs(File file, Modifications mods) throws IOException {
        boolean ok;
        if (!file.exists() && !(ok = file.mkdirs())) {
            throw new IOException("Could not create folder");
        }
        for (int i = 0; i < this.contents.size(); ++i) {
            String filename = this.contents.get(i);
            if (mods.isModified(filename)) {
                byte[] data = mods.getData(filename);
                this.write(new File(file, filename), data);
                continue;
            }
            this.write(new File(file, filename), this.getInputStream(filename));
        }
        this.f = file;
    }

    public void partialSave(String filename, byte[] data) throws IOException {
        File target = this.getTarget(filename);
        target.getParentFile().mkdirs();
        this.write(target, data);
    }

    @Override
    public void removeAllFiles() throws IOException {
        FileToolkit.deleteRecursively(this.f);
        this.f.mkdir();
        this.contents.clear();
    }

    public static Folder createNew(File file) throws IOException {
        Folder folder = new Folder();
        folder.f = file;
        folder.contents = new ArrayList<String>();
        file.mkdirs();
        return folder;
    }

    @Override
    public String getClasspath(String mainClass) {
        return this.f.getPath();
    }
}

