/*
 * Decompiled with CFR 0.152.
 */
package net.sf.rej;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Imports {
    private String homePackage;
    private Set<String> types = new TreeSet<String>();
    private List<String> allNames = new ArrayList<String>();
    private List<String> ambigous = new ArrayList<String>();

    public Imports(String homePackage) {
        this.homePackage = homePackage;
    }

    public void addType(String fullTypeName) {
        if (fullTypeName.indexOf(";") > -1) {
            throw new RuntimeException("invalid class");
        }
        if (!(Imports.isInDefaultPackage(fullTypeName) || Imports.getPackage(fullTypeName).equals(this.homePackage) || Imports.isInJavaLang(fullTypeName))) {
            this.types.add(fullTypeName);
        }
        if (!this.allNames.contains(fullTypeName)) {
            String shortName = Imports.getType(fullTypeName);
            for (int i = 0; i < this.allNames.size(); ++i) {
                String name = this.allNames.get(i);
                if (!Imports.getType(name).equals(shortName)) continue;
                this.ambigous.add(shortName);
                break;
            }
            this.allNames.add(fullTypeName);
        }
    }

    public Set<String> getImports() {
        TreeSet<String> fullList = new TreeSet<String>();
        ArrayList<String> tempList = new ArrayList<String>();
        Iterator<String> it = this.types.iterator();
        String last = "";
        while (it.hasNext()) {
            String name = it.next();
            if (tempList.size() != 0) {
                last = (String)tempList.get(tempList.size() - 1);
            }
            if (this.ambigous.contains(Imports.getType(name))) continue;
            if (!Imports.areInSamePackage(name, last)) {
                fullList.addAll(tempList);
                tempList.clear();
            }
            tempList.add(name);
        }
        if (tempList.size() > 0) {
            fullList.addAll(tempList);
            tempList.clear();
        }
        return fullList;
    }

    public static String getPackage(String type) {
        int i = type.lastIndexOf(".");
        if (i == -1) {
            return "";
        }
        return type.substring(0, i);
    }

    public static String getType(String type) {
        int i = type.lastIndexOf(".");
        if (i == -1) {
            return type;
        }
        return type.substring(i + 1);
    }

    public static boolean isInDefaultPackage(String type) {
        return type.indexOf(".") == -1;
    }

    public static boolean isInJavaLang(String type) {
        return "java.lang".equals(Imports.getPackage(type));
    }

    public static boolean areInSamePackage(String type1, String type2) {
        int i2;
        int i1 = type1.lastIndexOf(".");
        return i1 == (i2 = type2.lastIndexOf(".")) && (i1 == -1 || type1.substring(0, i1).equals(type2.substring(0, i2)));
    }

    public String getShortName(String fqn) {
        if (!this.ambigous.contains(Imports.getType(fqn)) && this.types.contains(fqn)) {
            int i = fqn.lastIndexOf(".");
            if (i != -1) {
                String name = fqn.substring(i + 1);
                return name;
            }
        } else if (Imports.isInJavaLang(fqn) || Imports.getPackage(fqn).equals(this.homePackage)) {
            int i = fqn.lastIndexOf(".");
            return fqn.substring(i + 1);
        }
        return fqn;
    }
}

