/* Copyright (c) 2016, 2017 Tyler McLellan  TyLabs.com
 * @tylabs
 * QuickSand.io - Document malware forensics tool
 *
 * File quicksand_exploits.yara   Nov 20 2017
 * Original source code available from https://github.com/tylabs/quicksand_lite
 * 
 * Decode and look in streams of Office Documents, RTF, MIME MSO.
 * XOR Database attack up to 256 byte keys to find embedded exe's.
 * Lite version - doesn't include cryptanalysis module and latest Office CVEs
 * Web version at http://quicksand.io/ has full features.
 *
 * Unless noted within the signature, signatures are subject to the terms
 * of the Mozilla Public License, v. 2.0. If a copy of the MPL was not
 * distributed with this file, You can obtain one at http://mozilla.org/MPL/2.0/. 
 *
 * Commercial licensing is available for the full version.
 */

rule warning_exec_ocx_object {
	meta:
		is_exploit = true
		is_warning = false
		is_feature = true
		rank = 5
		revision = "1"
		date = "July 29 2015"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "OLE application command"
	strings:
		$s1 = "w:ocx w:data=\"DATA:application/x-oleobject"
	condition:
            1 of them
}




rule warning_scriptbridge {
	meta:
		is_exploit = false
		is_warning = true
		is_feature = true
		rank = 5
		revision = "1"
		date = "July 29 2015"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "ScriptBridge may load remote exploit"
	strings:
		$s1 = "ScriptBridge.ScriptBridge.1"

	condition:
            1 of them
}



rule exploit_cve_2006_2492 {
	meta:
		is_exploit = true
		is_warning = false
		is_feature = false
		rank = 10
		revision = "1"
		date = "July 29 2015"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "smarttag overflow CVE-2006-2492"
	strings:
		$s1 = {0600DDC6040011000100D65A12000000000001000000060000000300}
		$s2 = {0600C8BE1B0008000200685B1200}
	condition:
            1 of them
}

rule exploit_cve_2009_3129 {
	meta:
		is_exploit = true
		is_warning = false
		is_feature = false
		rank = 10
		revision = "1"
		date = "July 29 2015"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "excel buffer overflow CVE-2009-3129"
	strings:
		$s1 = {4F7269656E746174696F6E??504F33}
	condition:
            1 of them
}


rule warning_embedded_flash {
	meta:
		is_exploit = false
		is_warning = true
		is_feature = true
		rank = 5
		revision = "1"
		date = "July 29 2015"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "Embedded Flash data"
	strings:
		$cws = {66556655??????00435753}
		$fws = {66556655??????00465753}
		$zws = {66556655??????005a5753}
		$control = "CONTROL ShockwaveFlash.ShockwaveFlash"
		$jit = {076A69745F656767}
		$generic = "ShockwaveFlash.ShockwaveFlash."
		$genericw = "ShockwaveFlash" wide
		$generich = "53686F636B77617665466C6173682E53686F636B77617665466C6173682E"

	condition:
            1 of them
}



rule exploit_cve_2011_0609 {
	meta:
		is_exploit = true
		is_warning = false
		is_feature = false
		rank = 10
		revision = "1"
		date = "July 29 2015"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "Flash exploit CVE-2011-0609"
	strings:
		$s1 = {4657530947CB0000480140005A0000190100441108000000BF141CCB0000000000000010002E00060080804094A8D0A001808004100002000000121212E24130F00931343134313431343134313431343134313431343134313431343134313431343134313431343134313431343134313431343134}
		$s2 = {34363537353330394541433730303030373830303036343030303030304338303030303032443031303034343131313830303030303034333032463446344634383630363036303230303031303030304646303931303030303030303033303030313030383630363036303130303032303030303430303030303030424631313235}
		$s3 = {3941303139413031394130313941303139064C6F61646572}

	condition:
            1 of them
}

rule exploit_cve_2011_0611 {
	meta:
		is_exploit = true
		is_warning = false
		is_feature = false
		rank = 10
		revision = "1"
		date = "July 29 2015"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "Flash exploit CVE-2011-061"
	strings:
		$s1 = {7772697465427974650541727261799817343635373533304143433035303030303738}
		$s2 = {5131645443737746414142346E453155625778545A52512B743733742B3362744B4E30596E617767552F414452654D5848334777597276757737597A643743674A734A6C76643174374E716D393959576D4B676B5A7674686C68446942556E344D694645453030514659306D456F664A2B4F45504D55594E6F69614C526D4E696A4D45494444665065652B3139663534652B35356E764F63383578376532766732514551504148514C6B45384248683175303937414B7741654943394F6A336579756277574E52793141564A475939326D4777444832794278794147636569424250524348}
		$s3 = {343635373533304143433035303030303738303030353546303030303046413030303030313830313030343431313030303030303030334630334137303530303030393630433030303530303037393543333743313330374642433337433133304531323944303230303443303439443032303031383030383831353030303930303431}
		$s4 = {3063306330633063306330633063306306537472696E6706}
		$s5 = {410042004300440045004600470048004900A18E110064656661756C74}
		$s6 = {00414243444500566B6475686752656D686677317375727772777C73680064656661756C740067657453697A650047647768317375727772777C73680077777273757277}
		$s7 = "AAB4AAVfAAAPoAAAGAEARBEAAAAAPwOnBQAAlgwABQAHlcN8Ewf7w3wTDhKdAgBMBJ0CABgAiBUACQBBAEIAQwBEAEUARgBHAEgASQChjhEAZGVmYXVsdAABAAQqAAIAmAGWCgAHWMBJSAenP7a3YJ0CAAAAmQIASQBAlgUABxZ0cAtMYp0CAAwAhwEAAxeHAQABlgoAB"
    

	condition:
            1 of them
}
    
    
    
rule exploit_cve_2012_0754 {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 10
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "Flash exploit malformed mp4 CVE-2012-0754"
    strings:
        $s1 = {537472696E6706586D6C537766094D6F766965436C6970076A69745F656767086368696C645265660D446973706C61794F626A656374074D79566964656F05566964656F044D794E430D4E6574436F6E6E656374696F6E}
    condition:
        1 of them
}


rule exploit_cve_2010_3333 {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 10
        revision = "1"
        date = "July 29 2015"
	release = "lite"
        author = "@tylabs"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "RTF stack overflow pFragments CVE-2010-3333"
    strings:
        $s1 = /sn .{1,300}?pFragments.{1,700}?sv .{1,200}?[a-zA-Z0-9\*\+]{50}?/
        $s2 = "\\sn\\*\\sn-pFragments"
        $s3 = /pFragments.{1,200}?\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x61\x0D\x0A/
        $s4 = /sn pfragments.{1,30}?11111111/
        $s5 = /sn[\W]{1,20}?pFragments/
        $s6 = "\\sn9pFRagMEnTS"
        $s7 = {5C736E34096D656E7473}
    condition:
        1 of them
}
    
    


    
    
rule warning_rtf_embedded_file {
    meta:
        is_exploit = false
        is_warning = true
        is_feature = true
        rank = 2
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_warning"
        desc = "TF embedded file package"
    strings:
        $s1 = /objdata.{1,300}\w*5\w*0\w*6\w*1\w*6\w*3\w*6\w*b\w*6\w*1\w*6\w*7\w*6\w*5\w*0\w*0/
        $s2 = "\\objclass Word.Document"
    condition:
        1 of them
}

    
rule exploit_MS12_060_tomato_garden {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 10
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "Office exploit MSCOMCTL.OCX Toolbar MS12-060 Tomato Garden campaign"
    strings:
        $s1 = "CONTROL MSComctlLib.Toolbar.2"
        $s2 = "Toolbar1, 0, 0, MSComctlLib, Toolbar"
        $s3 = "MSComctlLib.Toolbar.2"
        $s4 = {4D53436F6D63746C4C69622E546F6F6C6261722E32}
    condition:
        1 of them
}

    

rule warning_office_encrypted_doc {
    meta:
        is_exploit = false
        is_warning = true
        is_feature = true
        rank = 1
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "office encrypted document"
    strings:
        $s1 = {4D006900630072006F0073006F0066007400200042006100730065002000430072007900700074006F0067007200610070006800690063002000500072006F0076006900640065007200200076}
        $s2 = {45006E006300720079007000740065006400530075006D006D006100720079}
    condition:
        1 of them
}

    
    
    
rule exploit_cve_2012_1535 {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 10
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "Flash exploit CVE-2012-1535"
    strings:
        $s1 = {4578616D706C650B6372656174654C696E65730968656170537072617908686578546F42696E076D782E636F72650A49466C6578417373657409466F6E7441737365740A666C6173682E74657874}
        $s2 = {454D4245444445445F4346460A666F6E744C6F6F6B75700D456C656D656E74466F726D617408666F6E7453697A650B54657874456C656D656E7407636F6E74656E740E637265617465546578744C696E6508546578744C696E650178017906686569676874086164644368696C6406456E6469616E0D4C4954544C455F454E4449414E06656E6469616E223063306330633063}
    condition:
        1 of them
}


    
    
rule exploit_cve_2013_0634 {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 10
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "Flash exploit CVE-2013-0634 memory corruption"
    strings:
        $s1 = {8A23ABA78A01908B23EED461D8872396A39A02F48523A1F94AB48323FBE0E303}
    condition:
        1 of them
}
   
rule exploit_cve_2012_5054 {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 10
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "Flash exploit CVE-2012-5054 Matrix3D"
    strings:
        $s1 = {7772697465446F75626C65084D61747269783344064F626A6563740B666C6173682E6D6564696105536F756E640C666C6173682E73797374656D0C4361706162696C69746965730776657273696F6E0B746F4C6F776572436173651077696E}
    condition:
        1 of them
}
    
    
    

    
    
rule exploit_cve_2012_1856 {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 10
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "Office exploit MSCOMCTL.OCX TabStrip CVE-2012-1856"
    strings:
        $s1 = "MSComctlLib.TabStrip"
        $s2 = "4d53436f6d63746c4c69622e546162537472697" nocase
        $s3 = "9665fb1e7c85d111b16a00c0f0283628" nocase
        $s4 = "1EFB6596-857C-11D1-B16A-00C0F0283628" nocase

    condition:
        1 of them
    }
    
    
rule warning_mime_mso_embedded_flash {
    meta:
        is_exploit = false
        is_warning = true
        is_feature = true
        rank = 1
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
	release = "lite"
        sigtype = "cryptam_exploit"
        desc = "office embedded Flash in MSO file"
    strings:
        $s1 = "D27CDB6E-AE6D-11CF-96B8-444553540000" nocase
    condition:
        1 of them
}


    
rule exploit_cve_2012_0158 {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 10
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "Office exploit MSCOMCTL.OCX RCE CVE-2012-0158"
    strings:
        $s1 = /objdata.{1,100}?53436F6D63746C4C69622E4C/
        $s2 = "ListView2, 1, 1, MSComctlLib, ListView"
        $s3 = "ListView1, 1, 0, MSComctlLib, ListView"
        $s4 = /0000000000000000000000000000000000000000000000.{1,300}?49746D736400000002000000010000000C000000436F626A/
        $s5 = /MSComctlLib.ListViewCtrl.{1,25}?objdata/
        $s6 = "MSComctlLib.ListViewCtrl.2"
        $s7 = {4C00690073007400560069006500770041}
        $s8 = {ECBD010005009017190000000800000049746D736400000002000000010000000C000000436F626A??0000008282000082820000000000000000000000000000????????90}
        //$s9 = {3131313131313131310D0D0D1320434F4E54524F4C204D53436F6D63746C4C69622E4C697374566965774374726C2E32}
        $s10 = "978C9E23-D4B0-11CE-BF2D-00AA003F40D0" nocase
        $s11 = "BDD1F04B-858B-11D1-B16A-00C0F0283628" nocase
        $s12 = "C74190B6-8589-11D1-B16A-00C0F0283628" nocase
        $s13 = "996BF5E0-8044-4650-ADEB-0B013914E99C" nocase
        $s14 = "9181DC5F-E07D-418A-ACA6-8EEA1ECB8E9E" nocase
        $s15 = "\\7300740056006\\"
        $s16 = "4C69{\\*}7374566"
        $s17 = "4C0069007300740056006900650077004" nocase
        $s18 = "4BF0D1BD8B85D111B16A00C0F0283628" nocase
        $s19 = {4BF0D1BD8B85D111B16A00C0F0283628}
        $s20 = "COMCTL.TreeCtrl.1"
        $s21 = {434F4D43544C2E547265654374726C2E31}
	$s22 = "4D53436F6D63746C4C69622E4C697374566965774374726C2E" nocase
	$s23 = "MSComctlLib.ListViewCtrl.0"
	$s24 = {4D 53 43 6F 6D 63 74 6C 4C 69 62 2E 4C 69 73 74 56 69 65 77 43 74 72 6C 2E 30}
	$s25 = "4D53436F6D63746C4C69622E4C697374566965774374726C2E30" nocase


condition:
        1 of them
}
    
    
    
rule warning_activex_exec {
    meta:
        is_exploit = false
        is_warning = true
        is_feature = true
        rank = 8
        revision = "3"
        date = "Oct 11 2017"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015, 2017. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "ActiveX content"
    strings:
        $s1 = "MSComctlLib.TreeCtrl.2"
        $s2 = "4D53436F6D63746C4C69622E547265654374726C2E32" nocase
        $s3 = "B69041C78985D111B16A00AA003F40D0" nocase
    $s4 = {B69041C78985D111B16A00AA003F40D0}
    $s5 = "C74190B6-8589-11D1-B16A-00AA003F40D0" nocase
    $s6 = "C74190B6-8589-11D1-B16A-00C0F0283628" nocase
    $s7 = {B69041C78985D111B16A00C0F0283628}
    $s8 = "B69041C78985D111B16A00C0F0283628" nocase
    $s9 = "objclass MSComctlLib.ImageComboCtl.2"
    $s10 = "MSComctlLib.ImageComboCtl.2"
    $s11 = {00 4D 53 43 6F 6D 63 74 6C 4C 69 62 2E 49 6D 61 67
        65 43 6F 6D 62 6F 43 74 6C}
    $s12 = {49006D0061006700650043006F006D0062006F00430074006C002000}
    $s13 = "TreeView1, 0, 0, MSComctlLib, TreeView"
    $s14 = "new ActiveXObject"
    $s15 = "<ax:ocx ax:classid=" ascii nocase

    
    condition:
        1 of them
    }



    rule warning_vb_potential_heapspray {
    meta:
        is_exploit = false
        is_warning = true
        is_feature = true
        rank = 2
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
	release = "lite"
        sigtype = "cryptam_exploit"
        desc = "office heap spray"
    strings:
        $s1 = "90909090EB7F414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141412490909090"
    condition:
        1 of them
    }
    
    
    rule exploit_cve_2013_3906 {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 10
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "Office exploit TIFF CVE-2013-3906"
    strings:
        $s1 = {49492A00C8490000803FE0503824160D0784426150B864361D0F8844625138A4562D178C466351B8E4763D1F90486452392418012794496552B964B65D2F984C665339A4D66D379C4E6753B9E4F67D3FA05068543A25168D47A4526954BA65361D2894D3AA553AA556AD57AC566B55BAE576BD5FB0586C563B2596CD67B25424F68B65B6DD6FB85C6E573BA5D6ED77BC5E6F57BBE5F64751BF6070583C26170D87C4627158BC66371D8FA5DA80190CA6572D97CC667359BC5404803FE0503824160D0784426150B864361D0F88446251}
        $s2 = {49492a000800000002000e010200fc3a0000260000006987040001000000223b00007c5a00000a0a0a0a0a}
        $s3 = /jpegblip.{1,20}?49492a00cf660000ffff/
        
    condition:
        1 of them
}
    
    
    
    rule warning_package_manager_embedded {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 1
        revision = "2"
        date = "July 29 2015"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "Office package manager may load unsafe content such as shell scripts"
    strings:
        $s1 = "0003000C-0000-0000-c000-000000000046" nocase
        $s2 = "0c00030000000000c000000000000046"
        $s3 = {0c00030000000000c000000000000046}
	$s4 = "20a70df22fc0ce11927b0800095ae340" nocase
	$s5 = {20a70df22fc0ce11927b0800095ae340}
        $s7 = "Packager Shell Object" ascii wide
        
    condition:
        1 of them
    }
    

    rule exploit_eicar_test_file {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 10
        revision = "1"
        date = "July 29 2015"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
        tlp = "white"
        sigtype = "cryptam_exploit"
        desc = "eicar test signature"
    strings:
        $s1 = "EICAR-STANDARD-ANTIVIRUS-TEST-FILE"
        
    condition:
        $s1
    }




rule warning_vb_macro {
	meta:
		is_exploit = false
		is_warning = true
		is_feature = true
		rank = 3
		revision = "2"
		date = "Oct 5 2015"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "Visual Basic macro"
	strings:
		$s1 = "Name=\"VBAProject\"" nocase
		$s2 = "OLE Automation" wide nocase
		$s3 = "Visual Basic For Applications" wide nocase
		$s5 = "VBA6\\VBE6.DLL" wide nocase
		$s6 = "000204EF-0000-0000-C000-000000000046" ascii wide
		$s7 = "00020430-0000-0000-C000-000000000046" ascii wide
		$s8 = {000204EF00000000C000000000000046}
		$s9 = {0002043000000000C000000000000046}
		$s10 = "000204EF00000000C000000000000046"
		$s11 = "0002043000000000C000000000000046"
		$s12 = "wne:vbaSuppData" nocase
		$s13 = "wne:macroName" nocase

	condition:
            1 of them
}

rule warning_js_embed {
	meta:
		is_exploit = false
		is_warning = true
		is_feature = true
		rank = 3
		revision = "1"
		date = "Apr 12 2017"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2017. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "Embedded js"
	strings:
		$s1 = {6a 73 00}
		$s2 = "Package"
		$s3 = {2e 00 6a 00 73}
		$s4 = "Ole10Native" wide
	condition:
            3 of them
}


rule exploit_activex_execute_shell {
	meta:
		is_exploit = true
		is_warning = true
		is_feature = true
		rank = 3
		revision = "2"
		date = "July 29 2015"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "Visual Basic execute shell"
	strings:
		$s1 = "Wscript.Shell" nocase
		$s2 = "netsh firewall set opmode mode=disable" nocase
		$s3 = "Shell" nocase
		$s4 = "CreateObject" nocase
		$s5 = "GetObject" nocase
		$s6 = "SendKeys" nocase
		$s7 = "MacScript" nocase
		$s8 = "FollowHyperlink" nocase
		$s9 = "CreateThread" nocase
		$s10 = "ShellExecute" nocase
		$s11 = "shell.application" nocase
	condition:
            (warning_vb_macro or warning_js_embed) and 1 of them
}




rule warning_vb_autoopen {
	meta:
		is_exploit = false
		is_warning = true
		is_feature = true
		rank = 3
		revision = "1"
		date = "Oct 5 2015"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "Visual Basic macro"
	strings:
		$s1 = "Document_Open"
		$s2 = "AutoOpen"
		$s3 = "Document_Close"
		$s4 = "AutoExec"
		$s5 = "Auto_Open"
		$s6 = "AutoClose"
		$s7 = "Auto_Close"
		$s8 = "DocumentBeforeClose"
		$s9 = "DocumentChange"
		$s10 = "Document_New"
		$s11 = "NewDocument"
		$s12 = "Workbook_Open"
		$s13 = "Workbook_Close"

	condition:
            warning_vb_macro and 1 of them
}


rule warning_vb_fileio {
	meta:
		is_exploit = false
		is_warning = true
		is_feature = true
		rank = 4
		revision = "2"
		date = "July 29 2015"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2015. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "Visual Basic file io"
	strings:
		$s1 = "Scripting.FileSystemObject" nocase
		$s2 = "OpenTextFile"
		$s3 = "FileCopy"
		$s4 = "CopyFile"
		$s5 = "Kill"
		$s6 = "CreateTextFile"
		$s7 = "VirtualAlloc"
		$s8 = "RtlMoveMemory"
		$s9 = "URLDownloadToFileA"
		$s10 = "AltStartupPath"
		$s11 = "URLDownloadToFileA"
		$s12 = "ADODB.Stream"
		$s13 = "WriteText"
		$s14 = "SaveToFile"
		$s15 = "SaveAs"
		$s16 = "SaveAsRTF"
		$s17 = "FileSaveAs"
		$s18 = "MkDir"
		$s19 = "RmDir"
		$s20 = "SaveSetting"
		$s21 = "SetAttr"
	condition:
            warning_vb_macro and 1 of them
}


rule warning_ole2link_embedded {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 1
        revision = "3"
        date = "September 12 2017"
        author = "David Cannings"
        copyright = "source https://github.com/nccgroup/Cyber-Defence/blob/master/Technical%20Notes/Office%20zero-day%20(April%202017)/2017-04%20Office%20OLE2Link%20zero-day%20v0.4.md"
        tlp = "white"
        sigtype = "cryptam_warning"
        desc = "Office OLE2Link unsafe content such as remote risky content"
    strings:
        // Parsers will open files without the full 'rtf'
        $header_rtf = "{\\rt" nocase
        $header_office = { D0 CF 11 E0 }
        $header_xml = "<?xml version=" nocase wide ascii

        // Marks of embedded data (reduce FPs)
        // RTF format
        $embedded_object   = "\\object" nocase
        $embedded_objdata  = "\\objdata" nocase
        $embedded_ocx      = "\\objocx" nocase
        $embedded_objclass = "\\objclass" nocase
        $embedded_oleclass = "\\oleclsid" nocase
    
        // XML Office documents
        $embedded_axocx      = "<ax:ocx"  nocase wide ascii
        $embedded_axclassid  = "ax:classid"  nocase wide ascii

        // OLE format
        $embedded_root_entry = "Root Entry" wide
        $embedded_comp_obj   = "Comp Obj" wide
        $embedded_obj_info   = "Obj Info" wide
        $embedded_ole10      = "Ole10Native" wide

        $data0 = "00000300-0000-0000-C000-000000000046" nocase wide ascii
        $data1 = { 0003000000000000C000000000000046 }
        $data2 = "OLE2Link" nocase wide ascii
        $data3 = "4f4c45324c696e6b" nocase wide ascii
        $data4 = "StdOleLink" nocase wide ascii
        $data5 = "5374644f6c654c696e6b" nocase wide ascii

      condition:
        // Mandatory header plus sign of embedding, then any of the others
        1 of ($header*) and 1 of ($embedded*) 
            and (1 of ($data*))
    }

rule warning_EPS_xor_exec {
    meta:
        is_exploit = false
        is_warning = true
        is_feature = true
        rank = 5
        revision = "1"
        date = "May 11 2017"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2017. All rights reserved."
        tlp = "green"
        sigtype = "cryptam_exploit"
        desc = "EPS obfuscation using xor and exec"
    strings:
	$h1 = "%!PS-Adobe-" nocase
        $s1 = "mod get xor put"
	$s2 = "exec quit"

    condition:
	$h1 at 0 and all of ($s*)
    }


rule warning_vbs_embed {
	meta:
		is_exploit = false
		is_warning = true
		is_feature = true
		rank = 3
		revision = "1"
		date = "May 18 2017"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2017. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "Embedded vbs"
	strings:
		$s1 = {2e 76 62 73 00}
		$s2 = "Package"
		$s3 = {2e 00 76 00 62 00 73}
		$s4 = "Ole10Native" wide
	condition:
            3 of them
}

rule exploit_cve_2017_8759 {
    meta:
        is_exploit = true
        is_warning = false
        is_feature = false
        rank = 10
        revision = "1"
        date = "September 12 2017"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2017. All rights reserved."
        tlp = "green"
        sigtype = "cryptam_exploit"
        desc = "OLE WSDL Parser Code Injection in PrintClientProxy CVE-2017-8759"
	
    strings:
        $c5 = "wsdl=" ascii wide nocase
        $c7 = "wsdl=http" ascii wide nocase
	$c1 = "ECABB0C7-7F19-11D2-978E-0000F8757E2A"
	$c2 = "SoapMoniker"
	$c3 = "c7b0abec-197f-d211-978e-0000f8757e2a"
	$c4 = "c7b0abec197fd211978e0000f8757e2a"
	$c6 = {c7b0abec197fd211978e0000f8757e2a}
        
    condition:
        warning_ole2link_embedded and 1 of ($c*)
}

rule warning_js_inzip {
	meta:
		is_exploit = false
		is_warning = true
		is_feature = true
		rank = 3
		revision = "1"
		date = "Oct 9 2017"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2017. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "Embedded js"
	strings:
		$h1 = "PK"
		$s1 = {2e6a730a0020}
		$s2 = {2e6a73ad}
	condition:
            $h1 at 0 and all of ($s*)
}


rule warning_excel_dde_exec {
	meta:
		is_exploit = false
		is_warning = true
		is_feature = true
		rank = 5
		revision = "1"
		date = "Oct 10 2017"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2017. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "Embedded js"
	strings:
        	$header_xml = "<?xml version=" nocase wide ascii
		$dde = "instrText>DDE"
	condition:
            $header_xml and $dde
}

rule warning_rtf_objupdate {
	meta:
		is_exploit = false
		is_warning = true
		is_feature = true
		rank = 2
		revision = "1"
		date = "Nov 20 2017"
		author = "@tylabs"
		release = "lite"
		copyright = "QuickSand.io (c) Copyright 2017. All rights reserved."
		tlp = "white"
		sigtype = "cryptam_exploit"
		desc = "update RTF object may load malicious content"
	strings:
    	$header_xml = "{\\rt" nocase
		$upd = "\\objupdate" nocase
		
	condition:
		all of them
}

rule warning_powershell_strings {
    meta:
        is_exploit = false
        is_warning = true
        is_feature = false
        rank = 5
        revision = "1"
        date = "Feb 15 2018"
        author = "@tylabs"
	release = "lite"
        copyright = "QuickSand.io (c) Copyright 2017. All rights reserved."
        tlp = "red"
        sigtype = "cryptam_exploit"
        desc = "Powershell"
    strings:
        $s1 = "powershell.exe"
	$s2 = "-nop -w hidden -encodedcommand"
	$s3 = "Package"
	$s4 = "Ole10Native" wide


    condition:
	3 of them
    }
